/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging.service;

import de.drazil.nerdsuite.enums.TileAction;
import de.drazil.nerdsuite.imaging.service.AbstractImagingService;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import de.drazil.nerdsuite.widget.Tile;
import org.eclipse.swt.graphics.Rectangle;

public class RotationService
extends AbstractImagingService {
    public static final int CW = 1;
    public static final int CCW = 2;

    @Override
    public boolean needsConfirmation() {
        return this.checkIfSquareBase();
    }

    @Override
    public boolean isProcessConfirmed(boolean confirmAnyProcess) {
        return this.confirmable.isConfirmed("Tile does not have a square base.\nDo you really want to rotate this tile?\n\nTo prevent data loss click [No]");
    }

    private boolean checkIfSquareBase() {
        Rectangle r = this.service.getSelection();
        return this.service.getSelectedTile().isMulticolorEnabled() ? r.width / 2 != r.height : r.width != r.height;
    }

    @Override
    public void each(int action, int tileIndex, Tile tile, TileRepositoryService repositoryService, TileAction tileAction) {
        Rectangle selection = this.service.getSelection();
        int[] content = tile.getActiveLayer().getContent();
        int[] brush = tile.getActiveLayer().getBrush();
        int width = selection.width / (tile.isMulticolorEnabled() ? 2 : 1);
        int[] sourceContentSelection = new int[width * selection.height];
        int[] sourceBrushSelection = new int[width * selection.height];
        int[] targetContentSelection = new int[width * selection.height];
        int[] targetBrushSelection = new int[width * selection.height];
        int tileWidth = this.conf.getTileWidth();
        boolean multicolor = tile.isMulticolorEnabled();
        this.rotate(action, content, sourceContentSelection, targetContentSelection, tileWidth, selection, multicolor, width);
        if (brush != null && brush.length > 0) {
            this.rotate(action, brush, sourceBrushSelection, targetBrushSelection, tileWidth, selection, multicolor, width);
        }
    }

    private void rotate(int action, int[] data, int[] source, int[] target, int tileWidth, Rectangle selection, boolean multicolor, int width) {
        int cy;
        int y;
        int x = selection.x;
        int cx = 0;
        while (x < selection.x + selection.width) {
            y = selection.y;
            cy = 0;
            while (y < selection.y + selection.height) {
                source[cx + cy * width] = data[x + y * tileWidth];
                ++y;
                ++cy;
            }
            x += multicolor ? 2 : 1;
            ++cx;
        }
        int y2 = 0;
        while (y2 < selection.height) {
            int x2 = 0;
            while (x2 < width) {
                int b = source[x2 + y2 * width];
                int o = 0;
                if (action == 2) {
                    o = target.length - width - width * x2 + y2;
                } else if (action == 1) {
                    o = width - y2 - 1 + x2 * width;
                }
                if (o >= 0 && o < target.length) {
                    target[o] = b;
                }
                ++x2;
            }
            ++y2;
        }
        x = selection.x;
        cx = 0;
        while (x < selection.x + selection.width) {
            y = selection.y;
            cy = 0;
            while (y < selection.y + selection.height) {
                data[x + y * tileWidth] = target[cx + cy * width];
                if (multicolor) {
                    data[x + 1 + y * tileWidth] = target[cx + cy * width];
                }
                ++y;
                ++cy;
            }
            x += multicolor ? 2 : 1;
            ++cx;
        }
    }
}

