/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging.service;

import de.drazil.nerdsuite.enums.TileAction;
import de.drazil.nerdsuite.imaging.service.AbstractImagingService;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import de.drazil.nerdsuite.widget.Tile;
import org.eclipse.swt.graphics.Rectangle;

public class PurgeService
extends AbstractImagingService {
    @Override
    public boolean needsConfirmation() {
        return true;
    }

    @Override
    public boolean isProcessConfirmed(boolean confirmAnyProcess) {
        return this.confirmable.isConfirmed("Do you really want to purge this tile?");
    }

    @Override
    public void each(int action, int tileIndex, Tile tile, TileRepositoryService repositoryService, TileAction tileAction) {
        int[] content = tile.getActiveLayer().getContent();
        int[] brush = tile.getActiveLayer().getBrush();
        int tileWidth = this.conf.getTileWidth();
        Rectangle r = this.service.getSelection();
        Integer blankValue = repositoryService.getMetadata().getBlankValue();
        int x = r.x;
        while (x < r.x + r.width) {
            int y = r.y;
            while (y < r.y + r.height) {
                content[x + y * tileWidth] = 0;
                if (brush != null) {
                    brush[x + y * tileWidth] = blankValue;
                }
                ++y;
            }
            ++x;
        }
    }
}

