/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging.service;

import de.drazil.nerdsuite.enums.TileAction;
import de.drazil.nerdsuite.imaging.service.AbstractImagingService;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import de.drazil.nerdsuite.widget.Tile;
import org.eclipse.swt.graphics.Rectangle;

public class MirrorService
extends AbstractImagingService {
    public static final int UPPER_HALF = 1;
    public static final int LOWER_HALF = 2;
    public static final int LEFT_HALF = 3;
    public static final int RIGHT_HALF = 4;

    @Override
    public void each(int action, int tileIndex, Tile tile, TileRepositoryService repositoryService, TileAction tileAction) {
        int[] content = tile.getActiveLayer().getContent();
        int[] brush = tile.getActiveLayer().getBrush();
        Rectangle selection = this.service.getSelection();
        int tileWidth = this.conf.tileWidth;
        int loops = tile.isMulticolorEnabled() ? 2 : 1;
        this.mirror(action, content, tileWidth, selection, loops);
        if (brush != null && brush.length > 0) {
            this.mirror(action, brush, tileWidth, selection, loops);
        }
    }

    private void mirror(int action, int[] data, int tileWidth, Rectangle selection, int loops) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (action != 1) break block8;
                        int y = selection.y;
                        int c = 0;
                        while (y < selection.y + selection.height / 2) {
                            int x = selection.x;
                            while (x < selection.x + selection.width) {
                                data[x + (selection.y + selection.height - c - 1) * tileWidth] = data[x + y * tileWidth];
                                ++x;
                            }
                            ++y;
                            ++c;
                        }
                        break block9;
                    }
                    if (action != 2) break block10;
                    int y = selection.y;
                    int c = 0;
                    while (y < selection.y + selection.height / 2) {
                        int x = selection.x;
                        while (x < selection.x + selection.width) {
                            data[x + y * tileWidth] = data[x + (selection.y + selection.height - c - 1) * tileWidth];
                            ++x;
                        }
                        ++y;
                        ++c;
                    }
                    break block9;
                }
                if (action != 3) break block11;
                int y = selection.y;
                while (y < selection.y + selection.height) {
                    int x = selection.x;
                    int c = 0;
                    while (x < selection.x + selection.width / 2) {
                        data[selection.x + selection.width - 1 - c + y * tileWidth] = data[x + y * tileWidth];
                        ++x;
                        ++c;
                    }
                    ++y;
                }
                break block9;
            }
            if (action != 4) break block9;
            int y = selection.y;
            while (y < selection.y + selection.height) {
                int x = selection.x;
                int c = 0;
                while (x < selection.x + selection.width / 2) {
                    data[x + y * tileWidth] = data[selection.x + selection.width - 1 - c + y * tileWidth];
                    ++x;
                    ++c;
                }
                ++y;
            }
        }
    }
}

