/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging.service;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.enums.GridType;
import de.drazil.nerdsuite.imaging.service.ServiceFactory;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import de.drazil.nerdsuite.model.DirtyableImage;
import de.drazil.nerdsuite.widget.IColorPaletteProvider;
import de.drazil.nerdsuite.widget.ImagingWidgetConfiguration;
import de.drazil.nerdsuite.widget.Layer;
import de.drazil.nerdsuite.widget.Tile;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Display;

public class ImagePainterFactory {
    private Map<String, DirtyableImage> imagePool = new HashMap<String, DirtyableImage>();
    public static final int NONE = 0;
    public static final int READ = 1;
    public static final int UPDATE = 2;
    public static final int PIXEL = 4;
    public static final int SCALED = 8;
    public static final int UPDATE_PIXEL = 6;
    public static final int UPDATE_SCALED = 10;
    public static final String IMAGE_ID = "%s%sID%03X";
    private TileRepositoryService repository = null;
    private TileRepositoryService referenceRepository = null;
    private ImagingWidgetConfiguration conf;
    private int backgroundColorIndex = 0;
    private int foregroundColorIndex = 1;
    private IColorPaletteProvider colorProvider;
    private static final Map<String, ImagePainterFactory> cache = new HashMap<String, ImagePainterFactory>();

    public ImagePainterFactory(String name, IColorPaletteProvider colorProvider, ImagingWidgetConfiguration conf) {
        this.repository = ServiceFactory.getService(name, TileRepositoryService.class);
        if (this.repository.hasReference()) {
            this.referenceRepository = this.repository.getReferenceRepository();
        }
        this.conf = conf;
        this.colorProvider = colorProvider;
        cache.put(name, this);
    }

    public static final ImagePainterFactory getImageFactory(String name) {
        return cache.get(name);
    }

    public void resetCache() {
        for (DirtyableImage i : this.imagePool.values()) {
            i.getImage().dispose();
        }
        this.imagePool.clear();
    }

    public ImagingWidgetConfiguration getConfiguration() {
        return this.conf;
    }

    public void setForegroundColorIndex(int index) {
        this.foregroundColorIndex = index;
    }

    public int getForegroundColorIndex() {
        return this.foregroundColorIndex;
    }

    public void setBackgroundColorIndex(int index) {
        this.backgroundColorIndex = index;
    }

    public int setBackgroundColorIndex() {
        return this.backgroundColorIndex;
    }

    public void drawScaledImage(GC gc, Tile tile, String imageId, int x, int y) {
        this.drawScaledImage(gc, tile, imageId, x, y, false);
    }

    public void drawScaledImage(GC gc, Tile tile, String imageId, int x, int y, boolean thumbnail) {
        DirtyableImage scaledImage = tile.getActiveLayer().getImage(String.valueOf(imageId) + (thumbnail ? (char)'R' : 'P'));
        if (scaledImage == null || scaledImage.isDirty() || tile.isDirty()) {
            DirtyableImage masterImage;
            if (scaledImage != null) {
                scaledImage.dispose();
            }
            if ((masterImage = tile.getActiveLayer().getImage(imageId)) == null || masterImage.isDirty() || tile.isDirty()) {
                if (masterImage != null) {
                    masterImage.dispose();
                }
                masterImage = this.createOrUpdateLayer(imageId, tile.getActiveLayer(), true);
                masterImage.setDirty(false);
                System.out.println("create MasterImage");
            }
            Image i = masterImage.getImage();
            ImageData original = i.getImageData();
            int w = thumbnail ? this.conf.repositoryScaledTileWith : this.conf.painterScaledTileWith;
            int h = thumbnail ? this.conf.repositoryScaledTileHeight : this.conf.painterScaledTileHeight;
            int zoom = DPIUtil.getDeviceZoom();
            if (zoom > 100) {
                double zf = 100.0 / (double)zoom;
                h = (int)((double)h / zf);
                w = (int)((double)w / zf);
            }
            ImageData scaled = original.scaledTo(w, h);
            Image scaledImageInternal = new Image((Device)Display.getCurrent(), scaled);
            scaledImage = new DirtyableImage(scaledImageInternal, false);
            tile.getActiveLayer().putImage(String.valueOf(imageId) + (thumbnail ? (char)'R' : 'P'), scaledImage);
            tile.setDirty(false);
            System.out.println("create ScaledImage");
        }
        gc.drawImage(scaledImage.getImage(), x, y);
    }

    public DirtyableImage getGridLayer(boolean forceRepaint, Tile tile) {
        String name = this.conf.gridType.toString();
        DirtyableImage imageInternal = this.imagePool.get(name);
        if (imageInternal == null || forceRepaint) {
            imageInternal = this.createLayer(this.conf.painterScaledTileWith, this.conf.painterScaledTileHeight);
            GC gc = new GC((Drawable)imageInternal.getImage());
            gc.setForeground(this.conf.gridType == GridType.Line ? Constants.LINE_GRID_COLOR : Constants.PIXEL_GRID_COLOR);
            if (this.conf.gridType == GridType.Line) {
                int x = 0;
                while (x <= this.conf.iconWidth * this.conf.tileColumns) {
                    gc.drawLine(x * this.conf.pixelPaintWidth * this.conf.getScaleFactor(), 0, x * this.conf.pixelPaintWidth * this.conf.getScaleFactor(), this.conf.tileHeightPixel * this.conf.getScaleFactor());
                    x += tile.isMulticolorEnabled() ? 2 : 1;
                }
                int y = 0;
                while (y <= this.conf.iconHeight * this.conf.tileRows) {
                    gc.drawLine(0, y * this.conf.pixelPaintHeight * this.conf.getScaleFactor(), this.conf.tileWidthPixel * this.conf.getScaleFactor(), y * this.conf.pixelPaintHeight * this.conf.getScaleFactor());
                    ++y;
                }
            } else {
                int x = 0;
                while (x <= this.conf.iconWidth * this.conf.tileColumns) {
                    int y = 0;
                    while (y <= this.conf.iconHeight * this.conf.tileRows) {
                        gc.drawPoint(x * this.conf.pixelPaintWidth * this.conf.getScaleFactor(), y * this.conf.pixelPaintHeight * this.conf.getScaleFactor());
                        ++y;
                    }
                    x += tile.isMulticolorEnabled() ? 2 : 1;
                }
            }
            gc.dispose();
            this.imagePool.put(name, imageInternal);
        }
        return imageInternal;
    }

    public DirtyableImage createOrUpdateBaseImage(String name, Color color) {
        return this.createOrUpdateBaseImage(name, color, this.conf.tileWidthPixel, this.conf.tileHeightPixel);
    }

    public DirtyableImage createOrUpdateBaseImage(String name, Color color, int width, int height) {
        String internalName = String.format("%s_BASEIMAGE", name);
        DirtyableImage imageInternal = this.imagePool.get(internalName);
        if (imageInternal == null) {
            int zoom = DPIUtil.getDeviceZoom();
            if (zoom > 100) {
                double zf = 100.0 / (double)zoom;
                height = (int)((double)height / zf);
                width = (int)((double)width / zf);
            }
            imageInternal = new DirtyableImage(new Image((Device)Display.getDefault(), width, height), true);
            GC gc = new GC((Drawable)imageInternal.getImage());
            gc.setBackground(color);
            gc.fillRectangle(0, 0, width, height);
            gc.dispose();
            this.imagePool.put(internalName, imageInternal);
        }
        return imageInternal;
    }

    public DirtyableImage createLayer() {
        return this.createLayer(this.conf.tileWidthPixel, this.conf.tileHeightPixel);
    }

    public DirtyableImage createLayer(int width, int height) {
        int zoom = DPIUtil.getDeviceZoom();
        if (zoom > 100) {
            double zf = 100.0 / (double)zoom;
            height = (int)((double)height / zf);
            width = (int)((double)width / zf);
        }
        Image image = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)image);
        gc.setBackground(Constants.TRANSPARENT_COLOR);
        gc.fillRectangle(0, 0, width, height);
        gc.dispose();
        ImageData imageData = image.getImageData();
        imageData.transparentPixel = imageData.palette.getPixel(Constants.TRANSPARENT_COLOR.getRGB());
        image.dispose();
        DirtyableImage imageInternal = new DirtyableImage(new Image((Device)Display.getDefault(), imageData), true);
        return imageInternal;
    }

    public DirtyableImage createOrUpdateTilePixel(String id, Layer layer, int x, int y) {
        return this.createOrUpdateTilePixel(id, layer, x, y, false);
    }

    public DirtyableImage createOrUpdateTilePixel(String id, Layer layer, int x, int y, boolean isDirty) {
        if (this.repository.hasReference()) {
            return this._createOrUpdateTilePixelFromReference(id, layer, x, y, isDirty);
        }
        return this._createOrUpdateTilePixel(id, layer, x, y, isDirty);
    }

    private DirtyableImage _createOrUpdateTilePixel(String id, Layer layer, int x, int y, boolean isDirty) {
        DirtyableImage imageInternal = layer.getImage(id);
        GC gc = new GC((Drawable)imageInternal.getImage());
        gc.setForeground(this.colorProvider.getColorByIndex(this.foregroundColorIndex));
        int x1 = x * (this.repository.getSelectedTile().isMulticolorEnabled() ? 2 : 1);
        gc.drawPoint(x1, y);
        if (this.repository.getSelectedTile().isMulticolorEnabled()) {
            gc.drawPoint(x1 + 1, y);
        }
        gc.dispose();
        return imageInternal;
    }

    private DirtyableImage _createOrUpdateTilePixelFromReference(String id, Layer layer, int x, int y, boolean isDirty) {
        DirtyableImage imageInternal = layer.getImage(id);
        GC gc = new GC((Drawable)imageInternal.getImage());
        ImagePainterFactory ipf = ImagePainterFactory.getImageFactory(this.referenceRepository.getMetadata().getId());
        ImagingWidgetConfiguration conf = ipf.getConfiguration();
        int i = this.conf.tileWidth * y + x;
        int ci = layer.getContent()[i];
        int bi = layer.getBrush()[i];
        Tile pixelTile = this.referenceRepository.getTile(bi, true);
        Layer pixelLayer = pixelTile.getActiveLayer();
        String pixelId = String.format(IMAGE_ID, String.format("T%03X", bi), layer.getId(), ci);
        ipf.setForegroundColorIndex(ci);
        Image image = ipf.createOrUpdateLayer(pixelId, pixelLayer, false).getImage();
        gc.drawImage(image, x * conf.tileWidthPixel, y * conf.tileHeightPixel);
        gc.dispose();
        return imageInternal;
    }

    public DirtyableImage createOrUpdateLayer(String id, Layer layer, boolean isDirty) {
        DirtyableImage image = null;
        image = this.repository.hasReference() ? this._createOrUpdateLayerFromReference(id, layer, isDirty) : this._createOrUpdateLayer(id, layer, isDirty);
        return image;
    }

    private DirtyableImage _createOrUpdateLayer(String id, Layer layer, boolean isDirty) {
        DirtyableImage imageInternal = layer.getImage(id);
        if (imageInternal == null || isDirty) {
            if (isDirty && imageInternal != null) {
                layer.removeImage(id);
            }
            imageInternal = this.createLayer();
            imageInternal.setDirty(isDirty);
            GC gc = new GC((Drawable)imageInternal.getImage());
            int x = 0;
            int y = 0;
            int i = 0;
            while (i < this.conf.getTileSize()) {
                if (i % this.conf.tileWidth == 0 && i > 0) {
                    x = 0;
                    ++y;
                }
                int ci = layer.getContent()[i];
                Color c = null;
                c = this.repository.getSelectedTile().isMulticolorEnabled() ? this.colorProvider.getColorByIndex(layer.getColorPalette().get(ci)) : this.colorProvider.getColorByIndex(ci > 0 ? this.foregroundColorIndex : 0);
                gc.setForeground(c);
                gc.drawPoint(x, y);
                ++x;
                ++i;
            }
            gc.dispose();
            layer.putImage(id, imageInternal);
        }
        return imageInternal;
    }

    private DirtyableImage _createOrUpdateLayerFromReference(String id, Layer layer, boolean isDirty) {
        DirtyableImage imageInternal = layer.getImage(id);
        if (imageInternal == null || isDirty) {
            if (isDirty && imageInternal != null) {
                layer.removeImage(id);
            }
            imageInternal = this.createLayer();
            imageInternal.setDirty(isDirty);
            GC gc = new GC((Drawable)imageInternal.getImage());
            int x = 0;
            int y = 0;
            int i = 0;
            while (i < this.conf.getTileSize()) {
                if (i % this.conf.tileWidth == 0 && i > 0) {
                    x = 0;
                    ++y;
                }
                int ci = layer.getContent()[i];
                int bi = layer.getBrush()[i];
                Tile pixelTile = this.referenceRepository.getTile(bi, true);
                Layer pixelLayer = pixelTile.getActiveLayer();
                ImagePainterFactory ipf = ImagePainterFactory.getImageFactory(this.referenceRepository.getMetadata().getId());
                ImagingWidgetConfiguration conf = ipf.getConfiguration();
                String pixelId = String.format(IMAGE_ID, String.format("T%03X", bi), layer.getId(), ci);
                ipf.setForegroundColorIndex(ci);
                gc.drawImage(ipf.createOrUpdateLayer(pixelId, pixelLayer, false).getImage(), x * conf.tileWidthPixel, y * conf.tileHeightPixel);
                ++x;
                ++i;
            }
            gc.dispose();
            layer.putImage(id, imageInternal);
        }
        return imageInternal;
    }

    public DirtyableImage createOrUpdateTileMap(boolean isDirty) {
        String repositoryName = this.repository.getOwner();
        DirtyableImage mapImageInternal = this.imagePool.get(repositoryName);
        if (mapImageInternal == null) {
            mapImageInternal = new DirtyableImage(this.createLayer(this.conf.tileWidthPixel * this.conf.scaleFactor * this.conf.columns + (this.conf.columns - 1) * this.conf.tileGap, this.conf.tileHeightPixel * this.conf.scaleFactor * this.conf.rows + (this.conf.rows - 1) * this.conf.tileGap).getImage(), false);
            GC gc = new GC((Drawable)mapImageInternal.getImage());
            int i = 0;
            while (i < this.repository.getSize()) {
                Tile tile = this.repository.getTile(i);
                Layer layer = tile.getActiveLayer();
                String id = String.format(IMAGE_ID, tile.getId(), layer.getId(), this.foregroundColorIndex);
                DirtyableImage imageInternal = tile.getImage(id);
                if (imageInternal == null || isDirty) {
                    if (isDirty && imageInternal != null) {
                        imageInternal.getImage().dispose();
                        this.imagePool.remove(id);
                    }
                    imageInternal = this.createOrUpdateLayer(id, layer, false);
                    imageInternal.setDirty(isDirty);
                    tile.putImage(id, imageInternal);
                }
                int y = i / this.conf.columns * (this.conf.tileHeightPixel * this.conf.scaleFactor + this.conf.tileGap);
                int x = i % this.conf.columns * (this.conf.tileWidthPixel * this.conf.scaleFactor + this.conf.tileGap);
                ImageData original = imageInternal.getImage().getImageData();
                ImageData scaled = original.scaledTo(original.width * this.conf.scaleFactor, original.height * this.conf.scaleFactor);
                Image scaledImage = new Image((Device)Display.getCurrent(), scaled);
                gc.drawImage(scaledImage, x, y);
                scaledImage.dispose();
                ++i;
            }
            gc.dispose();
            this.imagePool.put(repositoryName, mapImageInternal);
        }
        return mapImageInternal;
    }

    public boolean hasImages() {
        return !this.imagePool.isEmpty();
    }

    public void clear() {
        this.imagePool.clear();
    }
}

