/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging.service;

import de.drazil.nerdsuite.imaging.service.IService;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import de.drazil.nerdsuite.model.GraphicMetadata;
import de.drazil.nerdsuite.widget.Layer;

public class IOBaseService
implements IService {
    String owner;

    protected static void convert(byte[] bitplane, int bytesToSkip, TileRepositoryService service, ConversionMode conversionMode) {
        block13: {
            int tileSize;
            int iconSize;
            int columns;
            int height;
            int width;
            String id;
            GraphicMetadata metadata;
            block12: {
                metadata = service.getMetadata();
                id = String.valueOf(metadata.getPlatform()) + "_" + metadata.getType();
                width = metadata.getWidth();
                height = metadata.getHeight();
                columns = metadata.getColumns();
                int rows = metadata.getRows();
                iconSize = width / metadata.getStorageEntity() * height;
                tileSize = iconSize * columns * rows;
                if (!metadata.getType().equals("PETSCII") && !metadata.getType().equals("SCREENSET")) break block12;
                if (bitplane.length / tileSize != 2) break block13;
                int i = 0;
                while (i < tileSize) {
                    Layer layer = service.getSelectedTile().getActiveLayer();
                    layer.getBrush()[i] = bitplane[i];
                    layer.getContent()[i] = bitplane[i + tileSize];
                    ++i;
                }
                break block13;
            }
            int size = tileSize * bitplane.length / tileSize;
            int bytesPerRow = width / metadata.getStorageEntity();
            int bitPerPixel = 1;
            int mask = 1;
            int o = 0;
            int tc = 0;
            while (o < size) {
                int[] workArray = null;
                if (conversionMode == ConversionMode.toWorkArray) {
                    service.addTile();
                    workArray = service.getActiveLayerFromSelectedTile().getContent();
                } else if (conversionMode == ConversionMode.toBitplane) {
                    workArray = service.getActiveLayerFromTile(tc).getContent();
                }
                int si = 0;
                int s = 0;
                while (si < tileSize) {
                    s = si % iconSize == 0 ? 0 : s;
                    int xo = (si / iconSize & columns - 1) * width;
                    int yo = si / (iconSize * columns) * height * width * columns;
                    int ro = s / bytesPerRow * width * columns;
                    int wai = ro + xo + yo;
                    int i = 0;
                    while (i < bytesPerRow) {
                        bitplane[o + si + i] = conversionMode == ConversionMode.toBitplane ? (byte)0 : bitplane[o + si + i];
                        int m = 7;
                        int ti = 0;
                        while (m >= 0) {
                            if (conversionMode == ConversionMode.toWorkArray) {
                                workArray[wai + 8 * i + ti] = (byte)(bitplane[o + si + i] >> m & mask);
                            } else if (conversionMode == ConversionMode.toBitplane) {
                                int n = o + si + i;
                                bitplane[n] = (byte)(bitplane[n] | workArray[wai + 8 * i + ti] << m);
                            }
                            m -= bitPerPixel;
                            ++ti;
                        }
                        ++i;
                    }
                    if (id.equals("C64_SPRITESET")) {
                        o += (si + bytesPerRow) % iconSize == 0 && si > 0 ? 1 : 0;
                    }
                    si += bytesPerRow;
                    s += bytesPerRow;
                }
                o += tileSize;
                ++tc;
            }
        }
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public static enum ConversionMode {
        toWorkArray,
        toBitplane;

    }
}

