/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging.service;

import de.drazil.nerdsuite.enums.TileAction;
import de.drazil.nerdsuite.imaging.service.AbstractImagingService;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import de.drazil.nerdsuite.widget.Tile;
import org.eclipse.swt.graphics.Rectangle;

public class FlipService
extends AbstractImagingService {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;

    @Override
    public void each(int action, int tileIndex, Tile tile, TileRepositoryService repositoryService, TileAction tileAction) {
        int[] content = tile.getActiveLayer().getContent();
        int[] brush = tile.getActiveLayer().getBrush();
        Rectangle selection = this.service.getSelection();
        int tileWidth = this.conf.tileWidth;
        int loops = tile.isMulticolorEnabled() ? 2 : 1;
        this.flip(action, content, tileWidth, selection, loops);
        if (brush != null && brush.length > 0) {
            this.flip(action, brush, tileWidth, selection, loops);
        }
    }

    private void flip(int action, int[] data, int tileWidth, Rectangle selection, int loops) {
        block5: {
            block4: {
                if (action != 1) break block4;
                int y = selection.y;
                while (y < selection.y + selection.height) {
                    int x = selection.x;
                    int c = 0;
                    while (x < selection.x + selection.width / 2) {
                        int b;
                        int a = data[x + y * tileWidth];
                        data[x + y * tileWidth] = b = data[selection.x + selection.width - 1 - c + y * tileWidth];
                        data[selection.x + selection.width - 1 - c + y * tileWidth] = a;
                        ++x;
                        ++c;
                    }
                    ++y;
                }
                break block5;
            }
            if (action != 2) break block5;
            int y = selection.y;
            int c = 0;
            while (y < selection.y + selection.height / 2) {
                int x = selection.x;
                while (x < selection.x + selection.width) {
                    int b;
                    int a = data[x + y * tileWidth];
                    data[x + y * tileWidth] = b = data[x + (selection.y + selection.height - c - 1) * tileWidth];
                    data[x + (selection.y + selection.height - c - 1) * tileWidth] = a;
                    ++x;
                }
                ++y;
                ++c;
            }
        }
    }
}

