/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging.service;

import de.drazil.nerdsuite.enums.Selection;
import de.drazil.nerdsuite.imaging.service.IService;
import de.drazil.nerdsuite.imaging.service.ServiceFactory;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import de.drazil.nerdsuite.widget.Layer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;

public class ClipboardService
implements IService {
    public static final int OFF = 0;
    public static final int CUT = 1;
    public static final int COPY = 2;
    public static final int PASTE = 4;
    private int initialAction;
    private List<Integer> selectionList;
    private Rectangle rangeSelection;
    private Selection selectionType = Selection.Unkown;
    private String sourceOwner;

    @Override
    public void setOwner(String owner) {
    }

    public void clipboardAction(int action, Selection selection, String owner) {
        block12: {
            block10: {
                TileRepositoryService service;
                block11: {
                    if (action != 1 && action != 2) break block10;
                    this.sourceOwner = owner;
                    service = ServiceFactory.getService(owner, TileRepositoryService.class);
                    this.initialAction = action;
                    this.selectionType = selection;
                    if (selection != Selection.List) break block11;
                    this.selectionList = new ArrayList<Integer>(service.getSelectedTileIndexList());
                    break block12;
                }
                if (selection != Selection.Range) break block12;
                this.rangeSelection = service.getSelection();
                break block12;
            }
            if (action == 4) {
                TileRepositoryService sourceService = ServiceFactory.getService(this.sourceOwner, TileRepositoryService.class);
                TileRepositoryService targetService = ServiceFactory.getService(owner, TileRepositoryService.class);
                if (this.selectionType == Selection.List) {
                    List<Integer> targetSelectionList = targetService.getSelectedTileIndexList();
                    int i = 0;
                    while (i < this.selectionList.size()) {
                        Layer sourceLayer = sourceService.getActiveLayerFromTile(this.selectionList.get(i));
                        Layer targetLayer = targetService.getActiveLayerFromTile(targetSelectionList.get(i));
                        targetLayer.setColorPalette(sourceLayer.getColorPalette());
                        int j = 0;
                        while (j < sourceLayer.getContent().length) {
                            targetLayer.getContent()[j] = sourceLayer.getContent()[j];
                            String ri = sourceService.getMetadata().getReferenceId();
                            if (ri != null) {
                                targetLayer.getBrush()[j] = sourceLayer.getBrush()[j];
                            }
                            ++j;
                        }
                        targetLayer.setDirty(true);
                        if (this.initialAction == 1) {
                            sourceService.getActiveLayerFromTile(this.selectionList.get(i)).reset(0, 0);
                        }
                        targetService.redrawTileViewer(targetSelectionList, 2, false);
                        ++i;
                    }
                } else if (this.selectionType == Selection.Range) {
                    int width = sourceService.getMetadata().getWidth();
                    Layer sourceLayer = sourceService.getActiveLayerFromTile(sourceService.getSelectedTileIndex());
                    Layer targetLayer = targetService.getActiveLayerFromTile(targetService.getSelectedTileIndex());
                    int y = this.rangeSelection.y;
                    int c = 0;
                    while (y < this.rangeSelection.y + this.rangeSelection.height) {
                        int x = this.rangeSelection.x;
                        while (x < this.rangeSelection.x + this.rangeSelection.width) {
                            targetLayer.getContent()[c] = sourceLayer.getContent()[x + y * width];
                            targetLayer.getBrush()[c] = sourceLayer.getBrush()[x + y * width];
                            ++x;
                            ++c;
                        }
                        ++y;
                    }
                }
            }
        }
    }
}

