/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging.service;

import de.drazil.nerdsuite.enums.AnimationMode;
import de.drazil.nerdsuite.imaging.service.AbstractImagingService;
import de.drazil.nerdsuite.imaging.service.ServiceFactory;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class AnimationService
extends AbstractImagingService {
    public static final int SET_DELAY = 4;
    private Animator animator = new Animator();
    private int delay = 100;
    private int pos = 0;
    private boolean animationIsRunning = false;
    private Composite composite;
    private List<Integer> animationIndex = new ArrayList<Integer>();
    private boolean forward = true;

    public AnimationService() {
        this.animationIndex.add(0);
    }

    public void startAnimation() {
        if (this.selectedTileIndexList.size() >= 1 && this.selectedTileIndexList.size() != 1) {
            this.animationIsRunning = true;
            this.composite.getDisplay().timerExec(0, (Runnable)this.animator);
        }
    }

    public void stopAnimation() {
        this.animationIsRunning = false;
        this.composite.getDisplay().timerExec(-1, (Runnable)this.animator);
    }

    public boolean isAnimationRunning() {
        return this.animationIsRunning;
    }

    public boolean isAnimatable() {
        return this.selectedTileIndexList.size() > 1;
    }

    public void execute(AnimationMode animationMode) {
        this.service = ServiceFactory.getService(this.owner, TileRepositoryService.class);
        this.selectedTileIndexList = this.service.getSelectedTileIndexList();
        if (animationMode == AnimationMode.Forward) {
            this.delay = 100;
            this.forward = true;
            this.stopAnimation();
            this.startAnimation();
        } else if (animationMode == AnimationMode.ForwardFast) {
            this.delay = 50;
            this.forward = true;
            this.stopAnimation();
            this.startAnimation();
        } else if (animationMode == AnimationMode.Stop) {
            this.pos = 0;
            this.stopAnimation();
        } else if (animationMode == AnimationMode.Backward) {
            this.delay = 100;
            this.forward = false;
            this.stopAnimation();
            this.startAnimation();
        } else if (animationMode == AnimationMode.BackwardFast) {
            this.delay = 50;
            this.forward = false;
            this.stopAnimation();
            this.startAnimation();
        }
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public class Animator
    implements Runnable {
        @Override
        public synchronized void run() {
            if (AnimationService.this.forward) {
                if (AnimationService.this.pos >= AnimationService.this.selectedTileIndexList.size()) {
                    AnimationService.this.pos = 0;
                }
            } else if (AnimationService.this.pos < 0) {
                AnimationService.this.pos = AnimationService.this.selectedTileIndexList.size() - 1;
            }
            int index = (Integer)AnimationService.this.selectedTileIndexList.get(AnimationService.this.pos);
            AnimationService.this.pos = AnimationService.this.pos + (AnimationService.this.forward ? 1 : -1);
            AnimationService.this.animationIndex.set(0, index);
            AnimationService.this.service.redrawTileViewer(AnimationService.this.animationIndex, 1, true);
            AnimationService.this.composite.getDisplay().timerExec(AnimationService.this.delay, (Runnable)this);
        }
    }
}

