/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging.service;

import de.drazil.nerdsuite.enums.LayerAction;
import de.drazil.nerdsuite.enums.TileAction;
import de.drazil.nerdsuite.imaging.service.AbstractExecutableService;
import de.drazil.nerdsuite.imaging.service.IConfirmable;
import de.drazil.nerdsuite.imaging.service.IImagingService;
import de.drazil.nerdsuite.imaging.service.IServiceCallback;
import de.drazil.nerdsuite.imaging.service.ServiceFactory;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import de.drazil.nerdsuite.model.TileLocation;
import de.drazil.nerdsuite.widget.ImagingWidgetConfiguration;
import de.drazil.nerdsuite.widget.Tile;
import java.util.List;

public abstract class AbstractImagingService
extends AbstractExecutableService
implements IImagingService {
    protected ImagingWidgetConfiguration conf = null;
    protected IServiceCallback serviceCallback = null;
    protected int navigationOffset = 0;
    protected List<Integer> selectedTileIndexList = null;
    protected IConfirmable confirmable;
    protected LayerAction layerAction = LayerAction.Active;
    protected TileRepositoryService service = null;

    @Override
    public boolean isProcessConfirmed(boolean confirmAnyProcess) {
        return false;
    }

    @Override
    public boolean isReadyToRun(List<TileLocation> tileLocationList, ImagingWidgetConfiguration configuration) {
        return false;
    }

    @Override
    public boolean needsConfirmation() {
        return false;
    }

    @Override
    public void sendResponse(String message, Object data) {
    }

    @Override
    public void execute() {
        this.execute(null);
    }

    @Override
    public void execute(IConfirmable confirmable) {
        this.execute(-1, confirmable);
    }

    @Override
    public void execute(int action) {
        this.execute(action, null);
    }

    @Override
    public void execute(int action, IConfirmable confirmable) {
        this.execute(action, confirmable, null);
    }

    @Override
    public void execute(int action, IConfirmable confirmable, IServiceCallback serviceCallback) {
        this.confirmable = confirmable;
        this.serviceCallback = serviceCallback;
        this.service = ServiceFactory.getService(this.owner, TileRepositoryService.class);
        this.selectedTileIndexList = this.service.getSelectedTileIndexList();
        if (this.needsConfirmation() && this.isProcessConfirmed(true) || !this.needsConfirmation()) {
            this.selectedTileIndexList.forEach(i -> {
                Tile tile = this.service.getTile((int)i);
                this.each(action, (int)i, tile, this.service, null);
                tile.setDirty(true);
            });
            this.service.redrawTileViewer(this.selectedTileIndexList, 2, false);
        }
    }

    public void each(int action, int tileIndex, Tile tile, TileRepositoryService repositoryService, TileAction tileAction) {
    }

    @Override
    public void setConf(ImagingWidgetConfiguration conf) {
        this.conf = conf;
    }

    public void setNavigationOffset(int navigationOffset) {
        this.navigationOffset = navigationOffset;
    }

    public void setLayerAction(LayerAction layerAction) {
        this.layerAction = layerAction;
    }
}

