/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging;

import de.drazil.nerdsuite.handler.BrokerObject;
import de.drazil.nerdsuite.imaging.AbstractStreamView;
import de.drazil.nerdsuite.model.RunObject;
import de.drazil.nerdsuite.network.TcpHandler;
import de.drazil.nerdsuite.widget.MemoryViewWidget;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class Ultimate64DebugStreamView
extends AbstractStreamView {
    private MemoryViewWidget imageViewer;
    private Thread debugThread;
    private DebugStreamReceiver debugStreamReceiver;
    private boolean running = false;
    private byte[] screen = new byte[1000];
    private byte[] color = new byte[1000];

    @Inject
    @Optional
    public void startStream(@UIEventTopic(value="StartStream") BrokerObject brokerObject) {
        this.startStream(0);
    }

    @Inject
    @Optional
    public void stopStream(@UIEventTopic(value="StopStream") BrokerObject brokerObject) {
        this.stopStream();
    }

    private void stopStream() {
        this.debugStreamReceiver.setRunning(false);
        this.stopStreamByCommand(65330);
        this.debugThread = null;
    }

    @Inject
    @Optional
    public void reset(@UIEventTopic(value="Reset") BrokerObject brokerObject) {
        try {
            this.stopStream();
            TimeUnit.MILLISECONDS.sleep(100L);
            this.reset();
            TimeUnit.MILLISECONDS.sleep(100L);
            this.startStream(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void startStream(int streamingMode) {
        String targetAdress = System.getProperty("u64.client.address");
        if (!this.running) {
            this.startStreamByCommand(65314, 0, targetAdress);
            this.debugThread = new Thread(this.debugStreamReceiver);
            this.debugThread.start();
            this.debugStreamReceiver.setRunning(true);
        }
    }

    private void stopStream(int streamingMode) {
        if ((streamingMode & 2) == 2 && this.debugStreamReceiver.isRunning()) {
            this.debugStreamReceiver.setRunning(false);
            this.stopStreamByCommand(65330);
            this.debugThread = null;
        }
    }

    @Inject
    @Optional
    public void loadAndRunObject(@UIEventTopic(value="LoadAndRun") BrokerObject brokerObject) {
        try {
            this.stopStream(65330);
            TimeUnit.MILLISECONDS.sleep(100L);
            RunObject runObject = (RunObject)brokerObject.getTransferObject();
            this.handleObject(runObject);
            TimeUnit.MILLISECONDS.sleep(2000L);
            this.startStream(65314);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PreDestroy
    public void preDestroy(MPart part) {
        this.stopStream();
        this.tcpHandler.closeSocket();
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.tcpHandler = new TcpHandler(System.getProperty("u64.host.address"), Integer.valueOf(System.getProperty("u64.host.port")));
        this.imageViewer = this.createImageViewer(parent);
        this.debugStreamReceiver = new DebugStreamReceiver();
        this.startStream(65314);
    }

    public MemoryViewWidget createImageViewer(Composite parent) {
        this.imageViewer = new MemoryViewWidget(parent, 0x20000000);
        this.imageViewer.setLayoutData(new GridData(4, 4, true, true));
        return this.imageViewer;
    }

    public class DebugStreamReceiver
    implements Runnable {
        private byte[] buf = new byte[1444];
        private int[] mem = new int[65536];
        private boolean running = false;
        private DatagramSocket socket;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized void run() {
            try {
                try {
                    this.socket = new DatagramSocket(11002);
                    while (this.socket != null) {
                        if (!this.running) {
                            return;
                        }
                        DatagramPacket packet = new DatagramPacket(this.buf, this.buf.length);
                        this.socket.receive(packet);
                        InetAddress address = packet.getAddress();
                        int port = packet.getPort();
                        packet = new DatagramPacket(this.buf, this.buf.length, address, port);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                int i = 4;
                                while (i < 1444) {
                                    int adr = (DebugStreamReceiver.this.buf[i + 1] << 8 | DebugStreamReceiver.this.buf[i + 0] & 0xFF) & 0xFFFF;
                                    int data = DebugStreamReceiver.this.buf[i + 2] & 0xFF;
                                    int flags = DebugStreamReceiver.this.buf[i + 3] & 0xFF;
                                    if (adr >= 1024 && adr <= 2023 && (flags & 1) == 1) {
                                        ((DebugStreamReceiver)DebugStreamReceiver.this).Ultimate64DebugStreamView.this.screen[adr - 1024] = (byte)(data & 0xFF);
                                    }
                                    if (adr >= 55296 && adr <= 56295) {
                                        ((DebugStreamReceiver)DebugStreamReceiver.this).Ultimate64DebugStreamView.this.color[adr - 55296] = (byte)(data & 0xF);
                                    }
                                    if (DebugStreamReceiver.this.mem[adr] != data) {
                                        DebugStreamReceiver.this.mem[adr] = data;
                                        ((DebugStreamReceiver)DebugStreamReceiver.this).Ultimate64DebugStreamView.this.imageViewer.setByte(adr, data, (flags & 1) == 0);
                                    }
                                    i += 4;
                                }
                            }
                        });
                    }
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.socket.close();
                    this.socket = null;
                    return;
                }
            }
            finally {
                this.socket.close();
                this.socket = null;
            }
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public boolean isRunning() {
            return this.running;
        }
    }
}

