/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.handler.BrokerObject;
import de.drazil.nerdsuite.imaging.AbstractStreamView;
import de.drazil.nerdsuite.model.Key;
import de.drazil.nerdsuite.model.PlatformColor;
import de.drazil.nerdsuite.model.RunObject;
import de.drazil.nerdsuite.network.TcpHandler;
import de.drazil.nerdsuite.util.NumericConverter;
import de.drazil.nerdsuite.widget.IHitKeyListener;
import de.drazil.nerdsuite.widget.ImageViewWidget;
import de.drazil.nerdsuite.widget.MemoryViewWidget;
import de.drazil.nerdsuite.widget.PlatformFactory;
import de.drazil.nerdsuite.widget.VirtualKeyboard;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Ultimate64AppStreamView
extends AbstractStreamView
implements IHitKeyListener {
    private ImageViewWidget imageViewer;
    private MemoryViewWidget memoryViewer;
    private VirtualKeyboard virtualKeyboard;
    private Thread videoThread;
    private Thread audioThread;
    private VideoStreamReceiver videoStreamReceiver;
    private AudioStreamReceiver audioStreamReceiver;
    private boolean lifeViewMode = false;
    private boolean virtualKeyboardVisible = false;
    private boolean isMute = false;
    private Composite parent;
    private Composite top;
    private Composite bottom;
    private SashForm verticalSash;
    private int streamingMode = 5;

    @Override
    public void keyPressed(Key key) {
        this.sendKeyboardSequence(key);
    }

    @Inject
    @Optional
    public void debugStream(@UIEventTopic(value="U64Debug") BrokerObject brokerObject) {
        this.lifeViewMode = !this.lifeViewMode;
        this.controlStream();
    }

    @Inject
    @Optional
    public void muteStream(@UIEventTopic(value="U64Mute") BrokerObject brokerObject) {
        this.isMute = !this.isMute;
        this.controlStream();
    }

    private void controlStream() {
        this.streamingMode = this.lifeViewMode ? 1 + (!this.isMute ? 4 : 0) : 2 + (!this.isMute ? 4 : 0);
    }

    @Inject
    @Optional
    public void dumpMemory(@UIEventTopic(value="ReadMemory") BrokerObject brokerObject) {
        byte[] screenDump = this.readMemory(1024, 1000);
        byte[] colorDump = this.readMemory(55296, 1000);
    }

    @Inject
    @Optional
    public void poke(@UIEventTopic(value="WriteMemory") BrokerObject brokerObject) {
        byte[] byArray = new byte[9];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        this.writeMemory(1024, byArray);
    }

    @Inject
    @Optional
    public void startStream(@UIEventTopic(value="StartStream") BrokerObject brokerObject) {
        this.startStream(5);
    }

    private void startStream(int streamingMode) {
        String targetAdress = System.getProperty("u64.client.address");
        if ((streamingMode & 1) == 1 && !this.videoStreamReceiver.isRunning()) {
            this.startStreamByCommand(65312, 0, targetAdress);
            this.imageViewer.drawImage(false);
            this.videoThread = new Thread(this.videoStreamReceiver);
            this.videoThread.start();
            this.videoStreamReceiver.setRunning(true);
        }
        if ((streamingMode & 4) == 4 && !this.audioStreamReceiver.isRunning()) {
            this.startStreamByCommand(65313, 0, targetAdress);
            this.audioThread = new Thread(this.audioStreamReceiver);
            this.audioThread.start();
            this.audioStreamReceiver.setRunning(true);
        }
    }

    @Inject
    @Optional
    public void stopStream(@UIEventTopic(value="StopStream") BrokerObject brokerObject) {
        this.stopStream(5);
    }

    private void stopStream(int streamingMode) {
        if ((streamingMode & 1) == 1 && this.videoStreamReceiver.isRunning()) {
            this.videoStreamReceiver.setRunning(false);
            this.stopStreamByCommand(65328);
            this.videoThread = null;
            this.imageViewer.drawImage(true);
        }
        if ((streamingMode & 4) == 4 && this.audioStreamReceiver.isRunning()) {
            this.audioStreamReceiver.setRunning(false);
            this.stopStreamByCommand(65329);
            this.audioThread = null;
        }
    }

    @Inject
    @Optional
    public void reset(@UIEventTopic(value="ResetU64") BrokerObject brokerObject) {
        try {
            this.stopStream(5);
            TimeUnit.MILLISECONDS.sleep(100L);
            this.reset();
            TimeUnit.MILLISECONDS.sleep(100L);
            this.startStream(5);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Inject
    @Optional
    public void virtualKeyboard(@UIEventTopic(value="VirtualKeyboard") BrokerObject brokerObject) {
        this.virtualKeyboardVisible = !this.virtualKeyboardVisible;
        this.virtualKeyboard.getParent().setVisible(this.virtualKeyboardVisible);
        if (!this.virtualKeyboardVisible) {
            this.showWithKeyboard(false);
            this.verticalSash.layout(true);
        } else {
            this.showWithKeyboard(true);
            this.verticalSash.layout(true);
        }
    }

    @Inject
    @Optional
    public void loadAndRunObject(@UIEventTopic(value="LoadAndRun") BrokerObject brokerObject) {
        try {
            this.stopStream(5);
            TimeUnit.MILLISECONDS.sleep(100L);
            RunObject runObject = (RunObject)brokerObject.getTransferObject();
            this.handleObject(runObject);
            TimeUnit.MILLISECONDS.sleep(2000L);
            this.startStream(5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Inject
    @Optional
    public void sendKeyboardSequence(Key key) {
        int code = key.getCode();
        if (key.getType().equals("KEY") || key.getType().equals("FUNCTION") || key.getType().equals("COLOR") && key.getOptionState() < 32) {
            if (code == 3) {
                byte[] ba = new byte[]{};
                ba = this.tcpHandler.buildCommand(ba, NumericConverter.getWord(65286), NumericConverter.getWord(3), this.tcpHandler.buildCommand(new byte[][]{NumericConverter.getWord(788)}), {123});
                ba = this.tcpHandler.buildCommand(ba, NumericConverter.getWord(65286), NumericConverter.getWord(3), this.tcpHandler.buildCommand(new byte[][]{NumericConverter.getWord(145)}), {127});
                this.tcpHandler.write(ba);
                ba = this.tcpHandler.buildCommand(ba, NumericConverter.getWord(65286), NumericConverter.getWord(3), this.tcpHandler.buildCommand(new byte[][]{NumericConverter.getWord(788)}), {49});
                ba = this.tcpHandler.buildCommand(ba, NumericConverter.getWord(65286), NumericConverter.getWord(3), this.tcpHandler.buildCommand(new byte[][]{NumericConverter.getWord(145)}), {-1});
                this.tcpHandler.write(ba);
            } else {
                byte[] codes = new byte[]{(byte)(code & 0xFF)};
                if (key.getName().equals("RUN")) {
                    codes = this.tcpHandler.buildCommand("RUN".getBytes(), {13});
                } else if (key.getName().equals("LIST")) {
                    codes = this.tcpHandler.buildCommand("LIST".getBytes(), {13});
                } else if (key.getName().equals("DIR")) {
                    codes = this.tcpHandler.buildCommand("LOAD\"$\",8".getBytes(), {13});
                } else if (key.getName().equals("LOAD*")) {
                    codes = this.tcpHandler.buildCommand("LOAD\"*\",8".getBytes(), {13});
                }
                this.sendKeyboardSequence(codes);
            }
        } else if (key.getType().equals("COLOR")) {
            byte[] ba = new byte[]{};
            if ((key.getOptionState() & 0x20) == 32) {
                ba = this.tcpHandler.buildCommand(ba, NumericConverter.getWord(65286), NumericConverter.getWord(3), NumericConverter.getWord(53280), {key.getIndex().byteValue()});
            }
            if ((key.getOptionState() & 0x40) == 64) {
                ba = this.tcpHandler.buildCommand(ba, NumericConverter.getWord(65286), NumericConverter.getWord(3), NumericConverter.getWord(53281), {key.getIndex().byteValue()});
            }
            this.tcpHandler.write(ba);
        }
    }

    @PreDestroy
    public void preDestroy(MPart part) {
        this.stopStream(5);
        this.tcpHandler.closeSocket();
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        this.parent = parent;
        this.tcpHandler = new TcpHandler(System.getProperty("u64.host.address"), Integer.valueOf(System.getProperty("u64.host.port")));
        List<PlatformColor> colorList = PlatformFactory.getPlatformColors("C64");
        RGB[] palette = new RGB[colorList.size()];
        int i = 0;
        while (i < palette.length) {
            palette[i] = colorList.get(i).getColor().getRGB();
            ++i;
        }
        parent.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Ultimate64AppStreamView.this.sendKeyboardSequence(new byte[]{(byte)e.character});
            }
        });
        this.verticalSash = new SashForm(parent, 512);
        this.verticalSash.setSashWidth(4);
        this.top = new Composite((Composite)this.verticalSash, 0);
        this.bottom = new Composite((Composite)this.verticalSash, 0);
        this.top.setLayout((Layout)new GridLayout(1, true));
        this.top.setBackground(Constants.BLACK);
        this.bottom.setLayout((Layout)new GridLayout(1, true));
        this.bottom.setBackground(Constants.GREY3);
        this.imageViewer = this.createImageViewer(this.top, new PaletteData(palette));
        this.imageViewer.setLayoutData(new GridData(2, 1040, true, true));
        this.virtualKeyboard = new VirtualKeyboard(this.bottom, 0, colorList);
        this.virtualKeyboard.addHitKeyListener(this);
        this.virtualKeyboard.setLayoutData(new GridData(2, 1040, true, true));
        this.showWithKeyboard(false);
        this.videoStreamReceiver = new VideoStreamReceiver();
        this.audioStreamReceiver = new AudioStreamReceiver();
        this.startStream(5);
    }

    private void showWithKeyboard(boolean keyboardEnabled) {
        this.verticalSash.setWeights(new int[]{1000, keyboardEnabled ? 350 : 0});
    }

    public ImageViewWidget createImageViewer(Composite parent, PaletteData pd) {
        return new ImageViewWidget(parent, 0x20000000, pd);
    }

    public MemoryViewWidget createMemoryImageViewer(Composite parent) {
        this.memoryViewer = new MemoryViewWidget(parent, 0x20000000);
        this.memoryViewer.setLayoutData(new GridData(4, 4, true, true));
        return this.memoryViewer;
    }

    private void sendKeyboardSequence(byte[] data) {
        if (this.tcpHandler.openSocket() != -1) {
            this.tcpHandler.write(this.tcpHandler.buildCommand(NumericConverter.getWord(65283), NumericConverter.getWord(data.length), data));
        }
    }

    private void showErrorDialog(String message) {
        MessageDialog.openError((Shell)this.parent.getShell(), (String)"Connection error", (String)message);
    }

    public class AudioStreamReceiver
    implements Runnable {
        private byte[] dataBuffer = new byte[770];
        private DatagramSocket socket;
        private boolean running = false;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized void run() {
            try {
                try {
                    this.socket = new DatagramSocket(11001);
                    AudioFormat af = new AudioFormat(48000.0f, 16, 2, true, false);
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, af);
                    SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
                    line.open(af, 4096);
                    line.start();
                    while (this.socket != null) {
                        if (!this.running) {
                            return;
                        }
                        DatagramPacket packet = new DatagramPacket(this.dataBuffer, this.dataBuffer.length);
                        this.socket.receive(packet);
                        InetAddress address = packet.getAddress();
                        int port = packet.getPort();
                        packet = new DatagramPacket(this.dataBuffer, this.dataBuffer.length, address, port);
                        int seq = NumericConverter.getWordAsInt(this.dataBuffer, 0);
                        line.write(this.dataBuffer, 2, this.dataBuffer.length - 2);
                    }
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.socket.close();
                    this.socket = null;
                    return;
                }
            }
            finally {
                this.socket.close();
                this.socket = null;
            }
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public boolean isRunning() {
            return this.running;
        }
    }

    public class VideoStreamReceiver
    implements Runnable {
        private byte[] data = new byte[52224];
        private byte[] dataBuffer = new byte[780];
        private boolean running = false;
        private int offset = 0;
        private DatagramSocket socket;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized void run() {
            try {
                try {
                    this.socket = new DatagramSocket(11000);
                    int count = 0;
                    while (this.socket != null) {
                        if (!this.running) {
                            return;
                        }
                        DatagramPacket packet = new DatagramPacket(this.dataBuffer, this.dataBuffer.length);
                        this.socket.receive(packet);
                        InetAddress address = packet.getAddress();
                        int port = packet.getPort();
                        packet = new DatagramPacket(this.dataBuffer, this.dataBuffer.length, address, port);
                        int seq = NumericConverter.getWordAsInt(this.dataBuffer, 0);
                        int line = NumericConverter.getWordAsInt(this.dataBuffer, 4);
                        if (this.offset < this.data.length) {
                            System.arraycopy(this.dataBuffer, 12, this.data, this.offset, this.dataBuffer.length - 12);
                            this.offset += this.dataBuffer.length - 12;
                        }
                        if ((line & 0x8000) == 32768) {
                            if (this.offset == this.data.length && count == 67) {
                                Ultimate64AppStreamView.this.imageViewer.addImageData(this.data);
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((VideoStreamReceiver)VideoStreamReceiver.this).Ultimate64AppStreamView.this.imageViewer.drawImage(false);
                                    }
                                });
                            }
                            count = 0;
                            this.offset = 0;
                            continue;
                        }
                        ++count;
                    }
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.socket.close();
                    this.socket = null;
                    return;
                }
            }
            finally {
                this.socket.close();
                this.socket = null;
            }
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public boolean isRunning() {
            return this.running;
        }
    }
}

