/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging;

import de.drazil.nerdsuite.configuration.Initializer;
import de.drazil.nerdsuite.enums.AnimationMode;
import de.drazil.nerdsuite.enums.CursorMode;
import de.drazil.nerdsuite.enums.GridType;
import de.drazil.nerdsuite.enums.PaintMode;
import de.drazil.nerdsuite.enums.PencilMode;
import de.drazil.nerdsuite.enums.RedrawMode;
import de.drazil.nerdsuite.enums.Selection;
import de.drazil.nerdsuite.handler.BrokerObject;
import de.drazil.nerdsuite.imaging.service.AnimationService;
import de.drazil.nerdsuite.imaging.service.ClipboardService;
import de.drazil.nerdsuite.imaging.service.FlipService;
import de.drazil.nerdsuite.imaging.service.IConfirmable;
import de.drazil.nerdsuite.imaging.service.ITileUpdateListener;
import de.drazil.nerdsuite.imaging.service.InvertService;
import de.drazil.nerdsuite.imaging.service.MirrorService;
import de.drazil.nerdsuite.imaging.service.MulticolorToggleService;
import de.drazil.nerdsuite.imaging.service.PurgeService;
import de.drazil.nerdsuite.imaging.service.RotationService;
import de.drazil.nerdsuite.imaging.service.ServiceFactory;
import de.drazil.nerdsuite.imaging.service.ShiftService;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import de.drazil.nerdsuite.model.GraphicFormat;
import de.drazil.nerdsuite.model.GraphicFormatVariant;
import de.drazil.nerdsuite.model.GraphicMetadata;
import de.drazil.nerdsuite.model.GridState;
import de.drazil.nerdsuite.model.Project;
import de.drazil.nerdsuite.util.E4Utils;
import de.drazil.nerdsuite.widget.ColorChooser;
import de.drazil.nerdsuite.widget.GraphicFormatFactory;
import de.drazil.nerdsuite.widget.IColorPaletteProvider;
import de.drazil.nerdsuite.widget.LayerChooser;
import de.drazil.nerdsuite.widget.PainterWidget;
import de.drazil.nerdsuite.widget.PlatformFactory;
import de.drazil.nerdsuite.widget.ReferenceWidget;
import de.drazil.nerdsuite.widget.RepositoryWidget;
import de.drazil.nerdsuite.widget.Tile;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GfxEditorView
implements ITileUpdateListener {
    private Composite parent;
    private PainterWidget painter;
    private RepositoryWidget repository;
    private ReferenceWidget referenceRepository;
    private ScrolledComposite scrollablePainter;
    private ScrolledComposite scrollableRepository;
    private ScrolledComposite scrollableLayerChooser;
    private TileRepositoryService tileRepositoryService;
    private TileRepositoryService tileRepositoryReferenceService;
    private IColorPaletteProvider colorPaletteProvider;
    private IConfirmable modificationConfirmation;
    private ColorChooser multiColorChooser;
    private LayerChooser layerChooser;
    private GraphicMetadata metadata = null;
    private GraphicFormat graphicFormat = null;
    private GraphicFormatVariant graphicFormatVariant = null;
    private Point actualSize;
    private Project project;
    private String owner;
    @Inject
    IEventBroker eventBroker;
    @Inject
    private MPart part;
    @Inject
    private EModelService modelService;
    private Composite toolPanel;
    private SashForm rightSash;
    private SashForm paintSash;

    @Inject
    @Optional
    public void managePencilMode(@UIEventTopic(value="PencilMode") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            PencilMode pencilMode = (PencilMode)((Object)brokerObject.getTransferObject());
            this.painter.getConf().setPencilMode(pencilMode);
        }
    }

    @Inject
    @Optional
    public void managePaintMode(@UIEventTopic(value="PaintMode") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            PaintMode paintMode = (PaintMode)((Object)brokerObject.getTransferObject());
            this.painter.getConf().setPaintMode(paintMode);
        }
    }

    @Inject
    @Optional
    public void manageShift(@UIEventTopic(value="Shift") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            ShiftService service = ServiceFactory.getService(this.owner, ShiftService.class);
            service.setConf(this.painter.getConf());
            service.execute((Integer)brokerObject.getTransferObject(), this.modificationConfirmation);
            this.part.setDirty(true);
        }
    }

    @Inject
    @Optional
    public void manageRotate(@UIEventTopic(value="Rotate") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            RotationService service = ServiceFactory.getService(this.owner, RotationService.class);
            service.setConf(this.painter.getConf());
            service.execute((Integer)brokerObject.getTransferObject(), this.modificationConfirmation);
            this.part.setDirty(true);
        }
    }

    @Inject
    @Optional
    public void manageFlip(@UIEventTopic(value="Flip") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            FlipService service = ServiceFactory.getService(this.owner, FlipService.class);
            service.setConf(this.painter.getConf());
            service.execute((Integer)brokerObject.getTransferObject(), this.modificationConfirmation);
            this.part.setDirty(true);
        }
    }

    @Inject
    @Optional
    public void manageInvert(@UIEventTopic(value="Invert") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            InvertService service = ServiceFactory.getService(this.owner, InvertService.class);
            service.setConf(this.painter.getConf());
            service.execute(0, this.modificationConfirmation);
            this.part.setDirty(true);
        }
    }

    @Inject
    @Optional
    public void manageMirror(@UIEventTopic(value="Mirror") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            MirrorService service = ServiceFactory.getService(this.owner, MirrorService.class);
            service.setConf(this.painter.getConf());
            service.execute((Integer)brokerObject.getTransferObject(), this.modificationConfirmation);
            this.part.setDirty(true);
        }
    }

    @Inject
    @Optional
    public void managePurge(@UIEventTopic(value="Purge") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            PurgeService service = ServiceFactory.getService(this.owner, PurgeService.class);
            service.setConf(this.painter.getConf());
            service.execute(this.modificationConfirmation);
            this.part.setDirty(true);
        }
    }

    @Inject
    @Optional
    public void manageMulticolor(@UIEventTopic(value="Multicolor") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            boolean multicolor = (Boolean)brokerObject.getTransferObject();
            this.multiColorChooser.setMulticolorEnabled(multicolor);
            MulticolorToggleService service = ServiceFactory.getService(this.owner, MulticolorToggleService.class);
            service.execute(multicolor ? 1 : 0);
            this.part.setDirty(true);
        }
    }

    @Inject
    @Optional
    public void manageGridState(@UIEventTopic(value="GridType") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            GridState gridState = (GridState)brokerObject.getTransferObject();
            this.painter.getConf().setGridType(gridState.gridType());
            this.painter.getConf().setPixelGridEnabled(gridState.enabled());
            this.painter.doRedraw(RedrawMode.DrawSelectedTile, 1);
        }
    }

    @Inject
    @Optional
    public void manageSelectionMode(@UIEventTopic(value="CursorMode") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            CursorMode cursorMode = (CursorMode)((Object)brokerObject.getTransferObject());
            this.painter.setCursorMode(cursorMode);
        }
    }

    @Inject
    @Optional
    public void animate(@UIEventTopic(value="AnimationMode") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            AnimationService service = ServiceFactory.getService(brokerObject.getOwner(), AnimationService.class);
            service.setComposite(this.parent);
            service.execute((AnimationMode)((Object)brokerObject.getTransferObject()));
        }
    }

    @Inject
    @Optional
    public void manageSave(@UIEventTopic(value="Save") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            this.save();
        }
    }

    @Inject
    @Optional
    public void manageTile(@UIEventTopic(value="Tile") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            if (((String)brokerObject.getTransferObject()).equalsIgnoreCase("add")) {
                this.tileRepositoryService.addTile();
            } else {
                ((String)brokerObject.getTransferObject()).equalsIgnoreCase("remove");
            }
            this.repository.recalc();
            this.part.setDirty(true);
        }
    }

    @Inject
    @Optional
    public void manageLayer(@UIEventTopic(value="Layer") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            if (!((String)brokerObject.getTransferObject()).equalsIgnoreCase("add")) {
                ((String)brokerObject.getTransferObject()).equalsIgnoreCase("remove");
            }
            this.repository.recalc();
            this.part.setDirty(true);
        }
    }

    @Inject
    @Optional
    public void clipboard(@UIEventTopic(value="Clipboard") BrokerObject brokerObject, MPart part) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            boolean isListSelection;
            boolean bl = isListSelection = this.tileRepositoryService.getSelectedTileIndexList().size() > 0;
            if (((String)brokerObject.getTransferObject()).equalsIgnoreCase("cut")) {
                ServiceFactory.getService("COMMON", ClipboardService.class).clipboardAction(1, isListSelection ? Selection.List : Selection.Range, this.owner);
            } else if (((String)brokerObject.getTransferObject()).equalsIgnoreCase("copy")) {
                ServiceFactory.getService("COMMON", ClipboardService.class).clipboardAction(2, isListSelection ? Selection.List : Selection.Range, this.owner);
            } else if (((String)brokerObject.getTransferObject()).equalsIgnoreCase("paste")) {
                ServiceFactory.getService("COMMON", ClipboardService.class).clipboardAction(4, Selection.Unkown, this.owner);
                part.setDirty(true);
            }
        }
    }

    @Inject
    @Optional
    public void export(@UIEventTopic(value="Export") BrokerObject brokerObject, MPart part) {
        System.out.printf("Export GFX %s\n", (String)brokerObject.getTransferObject());
    }

    @PreDestroy
    public void preDestroy(MApplication app, MTrimmedWindow window, EModelService modelService, MPart part) {
        part.isDirty();
    }

    @PostConstruct
    public void postConstruct(final Composite parent, MApplication app, MTrimmedWindow window, EMenuService menuService) {
        this.parent = parent;
        this.colorPaletteProvider = new IColorPaletteProvider(){

            @Override
            public Color getColor(Tile tile, int x, int y) {
                return null;
            }

            @Override
            public Color getColorByIndex(int index) {
                return PlatformFactory.getPlatformColors(GfxEditorView.this.tileRepositoryService.getMetadata().getPlatform()).get(index).getColor();
            }
        };
        this.modificationConfirmation = new IConfirmable(){

            @Override
            public boolean isConfirmed(String confirmationMessage) {
                return MessageDialog.openQuestion((Shell)parent.getShell(), (String)"Image Process Confirmation", (String)confirmationMessage);
            }
        };
        Map pm = (Map)this.part.getObject();
        this.project = (Project)pm.get("project");
        this.owner = (String)pm.get("repositoryOwner");
        this.tileRepositoryService = ServiceFactory.getService(this.project.getId(), TileRepositoryService.class);
        this.tileRepositoryReferenceService = this.tileRepositoryService.getReferenceRepository();
        this.metadata = this.tileRepositoryService.getMetadata();
        String graphicFormatId = String.valueOf(this.metadata.getPlatform()) + "_" + this.metadata.getType();
        this.graphicFormat = GraphicFormatFactory.getFormatById(graphicFormatId);
        this.graphicFormatVariant = GraphicFormatFactory.getFormatVariantById(graphicFormatId, this.metadata.getVariant());
        this.part.setDirty(false);
        this.part.getTransientData().put("OWNER", this.owner);
        this.part.setTooltip(String.valueOf(this.graphicFormat.getName()) + " " + this.graphicFormatVariant.getName());
        this.part.setIconURI("platform:/plugin/de.drazil.nerdsuite/" + this.project.getIconName());
        GridLayout mainGridLayout = new GridLayout(2, false);
        mainGridLayout.horizontalSpacing = 0;
        mainGridLayout.verticalSpacing = 0;
        parent.setLayout((Layout)mainGridLayout);
        GridData toolGridData = new GridData(2);
        this.toolPanel = new Composite(parent, 0);
        this.toolPanel.setLayoutData((Object)toolGridData);
        GridLayout toolGridLayout = new GridLayout(1, true);
        toolGridLayout.horizontalSpacing = 0;
        toolGridLayout.verticalSpacing = 0;
        this.toolPanel.setLayout((Layout)toolGridLayout);
        this.rightSash = new SashForm(parent, 512);
        GridData rightGridData = new GridData(4, 4, true, true);
        this.rightSash.setLayout((Layout)new FillLayout());
        this.rightSash.setSashWidth(4);
        this.rightSash.setLayoutData((Object)rightGridData);
        this.paintSash = new SashForm((Composite)this.rightSash, 256);
        this.paintSash.setSashWidth(4);
        this.paintSash.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GfxEditorView.this.getRepositoryWidget().redraw();
            }
        });
        this.painter = this.getPainterWidget();
        this.multiColorChooser = new ColorChooser(this.toolPanel, 0x20000000, this.graphicFormat.getId().endsWith("PETSCII") ? 2 : 4, PlatformFactory.getPlatformColors(this.tileRepositoryService.getMetadata().getPlatform()));
        GridData colorChooserData = new GridData(4, 2, true, true);
        this.multiColorChooser.setLayoutData(colorChooserData);
        if (this.tileRepositoryService.hasReference()) {
            this.referenceRepository = this.getReferenceRepositoryWidget();
        }
        this.layerChooser = this.createLayerChooser();
        GridData layerChooserData = new GridData(4, 2, true, true);
        this.layerChooser.setLayoutData(layerChooserData);
        this.repository = this.getRepositoryWidget();
        this.tileRepositoryService.addTileUpdateListener(this.painter, this.repository, this.layerChooser, this);
        this.tileRepositoryService.addTileManagementListener(this.painter, this.repository);
        this.multiColorChooser.addColorSelectionListener(this.painter);
        this.multiColorChooser.addColorSelectionListener(this.repository);
        menuService.registerContextMenu((Object)this.painter, "de.drazil.nerdsuite.popupmenu.GfxToolbox");
        menuService.registerContextMenu((Object)this.repository, "de.drazil.nerdsuite.popupmenu.GfxToolbox");
        this.actualSize = new Point(this.painter.getConf().getTileWidthPixel() * this.painter.getConf().getScaleFactor(), this.painter.getConf().getTileHeightPixel() * this.painter.getConf().getScaleFactor());
        this.scrollablePainter.setMinSize(this.actualSize);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LinkedList<String> tags = new LinkedList<String>();
                tags.add("MultiColorButton");
                boolean multicolor = GfxEditorView.this.tileRepositoryService.getSelectedTile().isMulticolorEnabled();
                MHandledItem item = E4Utils.getMenuITemByTag(GfxEditorView.this.part, GfxEditorView.this.modelService, tags);
                item.setSelected(multicolor);
                GfxEditorView.this.multiColorChooser.setMulticolorEnabled(multicolor);
                parent.getDisplay().getActiveShell().notifyListeners(11, new Event());
                GfxEditorView.this.painter.setCursorMode(CursorMode.Point);
                GfxEditorView.this.repository.doRedraw(RedrawMode.DrawAllTiles, 2);
                GfxEditorView.this.tileRepositoryService.hasReference();
                parent.layout();
            }
        });
    }

    public LayerChooser createLayerChooser() {
        this.scrollableLayerChooser = new ScrolledComposite(this.toolPanel, 0x20000300){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(180, 300);
            }
        };
        this.layerChooser = new LayerChooser((Composite)this.scrollableLayerChooser, 0x20100000, this.owner);
        return this.layerChooser;
    }

    public PainterWidget getPainterWidget() {
        if (this.scrollablePainter == null) {
            this.scrollablePainter = new ScrolledComposite((Composite)this.paintSash, 0x20000B00);
            this.scrollablePainter.addListener(11, event -> {});
            this.painter = new PainterWidget((Composite)this.scrollablePainter, 0x20100000, this.owner, this.colorPaletteProvider, false);
            this.painter.getConf().setPixelGridEnabled(true);
            this.painter.getConf().setGridType(GridType.Dot);
            this.painter.getConf().setTileGridEnabled(false);
            this.painter.getConf().setTileCursorEnabled(false);
            this.painter.getConf().setTileSubGridEnabled(!this.graphicFormat.getId().endsWith("SCREENSET") && !this.graphicFormat.getId().endsWith("PETSCII"));
            this.painter.getConf().setSeparatorEnabled(!this.graphicFormat.getId().endsWith("SCREENSET") && !this.graphicFormat.getId().endsWith("PETSCII"));
            this.painter.getConf().setTileSelectionModes(4);
            this.painter.getConf().setPixelSize(this.graphicFormatVariant.getPixelSize());
            this.painter.getConf().setScaleFactor(this.graphicFormatVariant.getScaleFactor());
            this.painter.getConf().computeDimensions();
            this.scrollablePainter.setContent((Control)this.painter);
            this.scrollablePainter.setExpandVertical(true);
            this.scrollablePainter.setExpandHorizontal(true);
        }
        return this.painter;
    }

    private RepositoryWidget getRepositoryWidget() {
        if (this.scrollableRepository == null) {
            this.scrollableRepository = new ScrolledComposite((Composite)this.rightSash, 0x20000A00);
            this.repository = new RepositoryWidget((Composite)this.scrollableRepository, 0x20100000, this.owner, this.colorPaletteProvider, true);
            this.repository.getConf().setPixelGridEnabled(false);
            this.repository.getConf().setTileGridEnabled(true);
            this.repository.getConf().setTileSubGridEnabled(false);
            this.repository.getConf().setTileCursorEnabled(true);
            this.repository.getConf().setSeparatorEnabled(false);
            this.repository.getConf().setTileGap(3);
            this.repository.getConf().setTileSelectionModes(3);
            this.repository.getConf().setPixelSize(this.graphicFormat.getId().endsWith("PETSCII") || this.graphicFormat.getId().endsWith("SCREENSET") ? 8 : 1);
            this.repository.getConf().setScaleFactor(-1);
            this.repository.getConf().computeDimensions();
            this.scrollableRepository.setContent((Control)this.repository);
            this.scrollableRepository.setExpandVertical(true);
            this.scrollableRepository.setExpandHorizontal(true);
            this.scrollableRepository.setMinSize(this.actualSize);
        }
        return this.repository;
    }

    private ReferenceWidget getReferenceRepositoryWidget() {
        if (this.referenceRepository == null) {
            this.referenceRepository = new ReferenceWidget((Composite)this.paintSash, 537921536, this.tileRepositoryReferenceService.getOwner(), this.colorPaletteProvider, false);
            this.referenceRepository.getConf().setRows(16);
            this.referenceRepository.getConf().setColumns(16);
            this.referenceRepository.getConf().setTileGap(3);
            this.referenceRepository.getConf().setPixelGridEnabled(false);
            this.referenceRepository.getConf().setTileGridEnabled(true);
            this.referenceRepository.getConf().setTileSubGridEnabled(false);
            this.referenceRepository.getConf().setTileCursorEnabled(true);
            this.referenceRepository.getConf().setSeparatorEnabled(false);
            this.referenceRepository.getConf().setPixelSize(1);
            this.referenceRepository.getConf().setScaleFactor(2);
            this.referenceRepository.getConf().setTileSelectionModes(1);
            this.referenceRepository.getConf().computeDimensions();
        }
        return this.referenceRepository;
    }

    @Override
    public void redrawTiles(List<Integer> selectedTileIndexList, RedrawMode redrawMode, int action) {
        boolean enableAnimationControls = redrawMode == RedrawMode.DrawSelectedTiles || redrawMode == RedrawMode.DrawTemporarySelectedTile;
        LinkedList<String> tags = new LinkedList<String>();
        tags.add("Animator");
        E4Utils.setToolItemEnabled(this.part, this.modelService, tags, enableAnimationControls);
        if (redrawMode == RedrawMode.DrawSelectedTile) {
            LinkedList<String> tags1 = new LinkedList<String>();
            tags1.add("MultiColorButton");
            Tile tile = this.tileRepositoryService.getTile(selectedTileIndexList.get(0));
            boolean multicolor = tile.isMulticolorEnabled();
            E4Utils.setToolItemSelected(this.part, this.modelService, tags1, multicolor);
        }
    }

    private void save() {
        System.out.println("save tiles");
        this.updateWorkspace(false);
        LocalDateTime ldt = LocalDateTime.now();
        Date d = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        this.project.setChangedOn(d);
        this.tileRepositoryService.save(this.project);
        this.part.setDirty(false);
    }

    @Persist
    private void close() {
        this.save();
    }

    private void updateWorkspace(boolean addProject) {
        Initializer.getConfiguration().updateWorkspace(this.project, addProject, false);
    }
}

