/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging;

import de.drazil.nerdsuite.model.RunObject;
import de.drazil.nerdsuite.network.TcpHandler;
import de.drazil.nerdsuite.util.NumericConverter;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

public class AbstractStreamView {
    protected TcpHandler tcpHandler;
    protected static final int VIC_STREAM_START_COMMAND = 65312;
    protected static final int VIC_STREAM_STOP_COMMAND = 65328;
    protected static final int SID_STREAM_START_COMMAND = 65313;
    protected static final int SID_STREAM_STOP_COMMAND = 65329;
    protected static final int DEBUG_STREAM_START_COMMAND = 65314;
    protected static final int DEBUG_STREAM_STOP_COMMAND = 65330;
    protected static final int VIDEO_STREAM = 1;
    protected static final int DEBUG_STREAM = 2;
    protected static final int AUDIO_STREAM = 4;

    protected void reset() {
        if (this.tcpHandler.openSocket() != -1) {
            this.tcpHandler.write(this.tcpHandler.buildCommand(NumericConverter.getWord(65284), new byte[2]));
        }
    }

    protected void wait(int delay) {
        if (this.tcpHandler.openSocket() != -1) {
            this.tcpHandler.write(this.tcpHandler.buildCommand(NumericConverter.getWord(65285), NumericConverter.getWord(delay)));
        }
    }

    protected byte[] readMemory(int address, int length) {
        byte[] data = null;
        if (this.tcpHandler.openSocket() != -1) {
            this.tcpHandler.write(this.tcpHandler.buildCommand(NumericConverter.getWord(65396), NumericConverter.getWord(length + 2), this.tcpHandler.buildCommand(new byte[][]{NumericConverter.getWord(address)})));
            try {
                InputStream is = this.tcpHandler.getInputStream();
                TimeUnit.MILLISECONDS.sleep(500L);
                int dataAvailable = 0;
                int av = is.available();
                while ((dataAvailable = is.available()) > 0) {
                    data = new byte[dataAvailable];
                    is.read(data, 0, dataAvailable);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    protected void writeMemory(int address, byte[] data) {
        if (this.tcpHandler.openSocket() != -1) {
            this.tcpHandler.write(this.tcpHandler.buildCommand(NumericConverter.getWord(65286), NumericConverter.getWord(data.length + 2), NumericConverter.getWord(address), data));
        }
    }

    protected void handleObject(RunObject runObject) {
        if (this.tcpHandler.openSocket() != -1) {
            int cmd_dma = 65281;
            int cmd_dma_run = 65282;
            int cmd_dma_jump = 65289;
            int cmd_dma_mount_img = 65290;
            int cmd_dma_run_img = 65291;
            byte[] command = null;
            if (runObject.getSource() == RunObject.Source.Program) {
                if (runObject.getMode() == RunObject.Mode.None && runObject.getStartAdress() == -1) {
                    command = this.tcpHandler.buildCommand(NumericConverter.getWord(cmd_dma), NumericConverter.getWord(runObject.getPayload().length));
                } else if (runObject.getMode() == RunObject.Mode.Run && runObject.getStartAdress() == -1) {
                    command = this.tcpHandler.buildCommand(NumericConverter.getWord(cmd_dma_run), NumericConverter.getWord(runObject.getPayload().length));
                } else if (runObject.getMode() == RunObject.Mode.Run && runObject.getStartAdress() != -1) {
                    command = this.tcpHandler.buildCommand(NumericConverter.getWord(cmd_dma_jump), NumericConverter.getWord(runObject.getPayload().length + 4), NumericConverter.getWord(runObject.getStartAdress()));
                }
            } else {
                byte[] l = NumericConverter.getLongWord(runObject.getPayload().length);
                byte[] length = new byte[]{l[0], l[1], l[2]};
                command = runObject.getMode() == RunObject.Mode.Run ? this.tcpHandler.buildCommand(NumericConverter.getWord(cmd_dma_run_img), length) : this.tcpHandler.buildCommand(NumericConverter.getWord(cmd_dma_mount_img), length);
            }
            this.tcpHandler.write(command);
            this.tcpHandler.write(runObject.getPayload());
        }
    }

    protected void startStreamByCommand(int command, int duration, String clientAdress) {
        byte[] durationArray = NumericConverter.getWord(duration);
        byte[] clientAdressArray = clientAdress.getBytes();
        byte[] length = NumericConverter.getWord(durationArray.length + clientAdressArray.length);
        if (this.tcpHandler.openSocket() != -1) {
            this.tcpHandler.write(this.tcpHandler.buildCommand(NumericConverter.getWord(command), length, durationArray, clientAdressArray));
        }
    }

    protected void stopStreamByCommand(int command) {
        if (this.tcpHandler.openSocket() != -1) {
            this.tcpHandler.write(this.tcpHandler.buildCommand(NumericConverter.getWord(command), new byte[2]));
        }
    }
}

