/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.handler;

import de.drazil.nerdsuite.widget.ImagingWidgetConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.graphics.Point;

public class SvgExport {
    int width = 30;
    int height = 30;
    boolean firstEntry = true;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 4;
    public static final int RIGHT = 8;
    private Map<String, List<SvgPoint>> pathMap = new HashMap<String, List<SvgPoint>>();

    @Execute
    public void execute(MPart part, IEventBroker broker) {
    }

    private int getOutlineRanges(int x, int y, int[] content, ImagingWidgetConfiguration conf) {
        int borders = 0;
        int iCenter = this.getIndex(x, y, conf);
        int iTop = this.getIndex(x, y - 1, conf);
        int iBottom = this.getIndex(x, y + 1, conf);
        int iLeft = this.getIndex(x - 1, y, conf);
        int iRight = this.getIndex(x + 1, y, conf);
        int vc = this.getValueAtIndex(iCenter, content);
        borders |= vc != this.getValueAtIndex(iTop, content) ? 1 : 0;
        borders |= vc != this.getValueAtIndex(iBottom, content) ? 4 : 0;
        borders |= vc != this.getValueAtIndex(iLeft, content) ? 2 : 0;
        return borders |= vc != this.getValueAtIndex(iRight, content) ? 8 : 0;
    }

    private int getValueAtIndex(int i, int[] content) {
        return i == -1 || i > content.length - 1 ? -1 : content[i];
    }

    private int getIndex(int x, int y, ImagingWidgetConfiguration conf) {
        if (x < 0 || y < 0 || x > conf.getTileWidth() || y > conf.getTileHeight()) {
            return -1;
        }
        return y * conf.getTileWidth() + x;
    }

    private Point getPoint(int i, ImagingWidgetConfiguration conf) {
        return new Point(i % conf.getTileHeight(), i / conf.getTileWidth());
    }

    private class SvgPoint {
        int x1;
        int y1;
        int x2;
        int y2;
        boolean isStartPoint;

        public SvgPoint(int x1, int y1, int x2, int y2, boolean isStartPoint) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.isStartPoint = isStartPoint;
        }

        public SvgPoint() {
        }

        public int getX1() {
            return this.x1;
        }

        public int getY1() {
            return this.y1;
        }

        public int getX2() {
            return this.x2;
        }

        public int getY2() {
            return this.y2;
        }

        public boolean isStartPoint() {
            return this.isStartPoint;
        }

        public void setX1(int x1) {
            this.x1 = x1;
        }

        public void setY1(int y1) {
            this.y1 = y1;
        }

        public void setX2(int x2) {
            this.x2 = x2;
        }

        public void setY2(int y2) {
            this.y2 = y2;
        }

        public void setStartPoint(boolean isStartPoint) {
            this.isStartPoint = isStartPoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SvgPoint)) {
                return false;
            }
            SvgPoint other = (SvgPoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getX1() != other.getX1()) {
                return false;
            }
            if (this.getY1() != other.getY1()) {
                return false;
            }
            if (this.getX2() != other.getX2()) {
                return false;
            }
            if (this.getY2() != other.getY2()) {
                return false;
            }
            return this.isStartPoint() == other.isStartPoint();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SvgPoint;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getX1();
            result = result * 59 + this.getY1();
            result = result * 59 + this.getX2();
            result = result * 59 + this.getY2();
            result = result * 59 + (this.isStartPoint() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "SvgExport.SvgPoint(x1=" + this.getX1() + ", y1=" + this.getY1() + ", x2=" + this.getX2() + ", y2=" + this.getY2() + ", isStartPoint=" + this.isStartPoint() + ")";
        }
    }
}

