/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.explorer;

import de.drazil.nerdsuite.basic.encode.SourceRepositoryService;
import de.drazil.nerdsuite.configuration.Configuration;
import de.drazil.nerdsuite.configuration.Initializer;
import de.drazil.nerdsuite.handler.BrokerObject;
import de.drazil.nerdsuite.imaging.service.ServiceFactory;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import de.drazil.nerdsuite.model.Project;
import de.drazil.nerdsuite.model.ProjectFolder;
import de.drazil.nerdsuite.model.RunObject;
import de.drazil.nerdsuite.storagemedia.IMediaContainer;
import de.drazil.nerdsuite.storagemedia.MediaEntry;
import de.drazil.nerdsuite.storagemedia.MediaFactory;
import de.drazil.nerdsuite.util.BinaryFileHandler;
import de.drazil.nerdsuite.util.E4Utils;
import de.drazil.nerdsuite.util.FileUtil;
import de.drazil.nerdsuite.util.ImageFactory;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Explorer
implements IDoubleClickListener {
    private TreeViewer treeViewer;
    @Inject
    MApplication app;
    @Inject
    EMenuService menuService;
    @Inject
    EPartService partService;
    @Inject
    EModelService modelService;

    @Inject
    public void postConstruct(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout(256));
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.treeViewer = new TreeViewer(container, 0);
        this.treeViewer.addDragSupport(1, transferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                super.dragSetData(event);
            }
        });
        this.treeViewer.addDropSupport(1, transferTypes, (DropTargetListener)new ViewerDropAdapter((Viewer)this.treeViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return false;
            }

            public boolean performDrop(Object data) {
                return false;
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new ProjectStructureProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProjectStructureLabelProvider());
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.menuService.registerContextMenu((Object)this.treeViewer.getTree(), "de.drazil.nerdsuite.popupmenu.fileexplorer");
        this.listFiles();
    }

    @Inject
    @Optional
    void exportFile(@UIEventTopic(value="Export") BrokerObject brokerObject) {
        TreeSelection treeNode = (TreeSelection)this.treeViewer.getSelection();
        Object o = treeNode.getFirstElement();
        if (!(o instanceof Project)) {
            if (o instanceof MediaEntry && !((MediaEntry)o).isDirectory()) {
                MediaEntry entry = (MediaEntry)o;
                IMediaContainer mediaManager = MediaFactory.mount((File)entry.getUserObject());
                FileDialog saveDialog = new FileDialog(this.treeViewer.getControl().getShell(), 8192);
                saveDialog.setFileName(String.valueOf(entry.getName()) + "." + entry.getType());
                String fileName = saveDialog.open();
                try {
                    mediaManager.exportEntry(entry, new File(fileName));
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Information", (String)("\"" + fileName + "\" was successfully exported."));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Folders can not be exported.");
            }
        }
    }

    @Inject
    @Optional
    void U64_LoadAndRun(@UIEventTopic(value="U64_LoadAndRun") BrokerObject brokerObject, IEventBroker broker) {
        TreeSelection treeNode = (TreeSelection)this.treeViewer.getSelection();
        Object o = treeNode.getFirstElement();
        if (o instanceof Project) {
            try {
                String fileName = ((Project)o).getMountLocation().split("@")[1];
                byte[] data = BinaryFileHandler.readFile(new File(fileName), 0);
                RunObject source = new RunObject();
                source.setPayload(data);
                source.setMode(RunObject.Mode.Run);
                source.setSource(fileName.toLowerCase().endsWith("d64") ? RunObject.Source.DiskImage : RunObject.Source.Program);
                broker.send("LoadAndRun", (Object)new BrokerObject("", source));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (o instanceof MediaEntry && !((MediaEntry)o).isDirectory()) {
            MediaEntry entry = (MediaEntry)o;
            IMediaContainer mediaContainer = MediaFactory.mount((File)entry.getUserObject());
            try {
                byte[] data = mediaContainer.exportEntry(entry);
                RunObject source = new RunObject();
                source.setPayload(data);
                source.setMode(RunObject.Mode.Run);
                source.setSource(entry.getName().toLowerCase().endsWith("d64") ? RunObject.Source.DiskImage : RunObject.Source.Program);
                broker.send("LoadAndRun", (Object)new BrokerObject("", source));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Folders can not be started on Ultimate64");
        }
    }

    private void listFiles() {
        List<Project> projectList = Initializer.getConfiguration().getWorkspace().getProjects();
        Configuration.WORKSPACE_PATH.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.getName().startsWith(".");
            }
        });
        this.treeViewer.setInput(projectList);
    }

    @Inject
    @Optional
    public void refresh(@UIEventTopic(value="explorer/refresh") Object value) {
        this.listFiles();
    }

    public void doubleClick(DoubleClickEvent event) {
        TreeSelection selection = (TreeSelection)event.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof Project) {
            Project project = (Project)element;
            System.out.println(project.getName());
            HashMap<String, Object> projectSetup = new HashMap<String, Object>();
            projectSetup.put("project", project);
            String owner = project.getId();
            if (project.getSuffix().startsWith("ns_")) {
                MPerspective perspective = (MPerspective)this.modelService.find("de.drazil.nerdsuite.perspective.GfxPerspective", (MUIElement)this.app);
                this.partService.switchPerspective(perspective);
                MUIElement editor = this.modelService.find(owner, (MUIElement)this.app);
                if (editor == null) {
                    System.out.println("load tiles");
                    File file = FileUtil.getFileFromProject(project);
                    TileRepositoryService repository = ServiceFactory.getService(owner, TileRepositoryService.class);
                    repository.load(owner);
                    projectSetup.put("repositoryOwner", owner);
                    projectSetup.put("file", file);
                    MPart part = E4Utils.createPart(this.partService, "de.drazil.nerdsuite.partdescriptor.GfxEditorView", "bundleclass://de.drazil.nerdsuite/de.drazil.nerdsuite.imaging.GfxEditorView", owner, project.getName(), projectSetup);
                    E4Utils.addPart2PartStack(this.app, this.modelService, this.partService, "de.drazil.nerdsuite.partstack.gfxEditorStack", part, true);
                } else {
                    editor.getParent().setSelectedElement(editor);
                }
            } else if (project.getSuffix().equals("bas")) {
                MPerspective perspective = (MPerspective)this.modelService.find("de.drazil.nerdsuite.perspective.CodingPerspective", (MUIElement)this.app);
                this.partService.switchPerspective(perspective);
                MUIElement editor = this.modelService.find(owner, (MUIElement)this.app);
                if (editor == null) {
                    System.out.println("load source");
                    File file = FileUtil.getFileFromProject(project);
                    SourceRepositoryService repository = ServiceFactory.getService(owner, SourceRepositoryService.class);
                    repository.load(owner);
                    projectSetup.put("repositoryOwner", owner);
                    projectSetup.put("file", file);
                    MPart part = E4Utils.createPart(this.partService, "de.drazil.nerdsuite.partdescriptor.SourceEditorView", "bundleclass://de.drazil.nerdsuite/de.drazil.nerdsuite.sourceeditor.SourceEditorView", owner, project.getName(), projectSetup);
                    E4Utils.addPart2PartStack(this.app, this.modelService, this.partService, "de.drazil.nerdsuite.partstack.codingEditorStack", part, true);
                } else {
                    editor.getParent().setSelectedElement(editor);
                }
            }
        }
    }

    private class ProjectStructureLabelProvider
    extends StyledCellLabelProvider {
        private ProjectStructureLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object o = cell.getElement();
            if (o instanceof Project) {
                Project project = (Project)o;
                cell.setText(project.getName());
                String iconName = "icons/bricks.png";
                if (project.isSingleFileProject()) {
                    iconName = project.getIconName();
                }
                cell.setImage(ImageFactory.createImage(iconName));
            } else if (o instanceof ProjectFolder) {
                cell.setText(((ProjectFolder)o).getName());
                cell.setImage(ImageFactory.createImage("icons/folder.png"));
            } else if (o instanceof MediaEntry) {
                MediaEntry file = (MediaEntry)o;
                cell.setText(file.getFullName());
                cell.setImage(ImageFactory.createImage(file.isDirectory() ? "icons/folder.png" : "icons/document-binary.png"));
            } else {
                File file = (File)o;
                if (file.getName().startsWith("prj")) {
                    cell.setText(file.getName().substring(4));
                    cell.setImage(ImageFactory.createImage("icons/bricks.png"));
                } else {
                    cell.setText(file.getName());
                    cell.setImage(ImageFactory.createImage("icons/folder.png"));
                }
                if (MediaFactory.filePattern.matcher(file.getName()).find()) {
                    cell.setImage(ImageFactory.createImage("icons/disk.png"));
                }
            }
        }
    }

    private class ProjectStructureProvider
    implements ITreeContentProvider {
        private ProjectStructureProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object[] array = null;
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                array = list.toArray(new Object[list.size()]);
            } else {
                array = (Object[])inputElement;
            }
            return array;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] entries = null;
            if (parentElement instanceof Project) {
                File file;
                Project project = (Project)parentElement;
                if (project.isMountpoint() && MediaFactory.isMountable(file = new File(project.getMountLocation()))) {
                    IMediaContainer mediaManager = MediaFactory.mount(file);
                    entries = mediaManager.getEntries(parentElement);
                }
            } else if (!(parentElement instanceof ProjectFolder)) {
                if (parentElement instanceof File) {
                    File parentFile = (File)parentElement;
                    if (MediaFactory.isMountable(parentFile)) {
                        IMediaContainer mediaManager = MediaFactory.mount(parentFile);
                        entries = mediaManager.getEntries(parentElement);
                    } else {
                        entries = parentFile.listFiles();
                    }
                } else if (parentElement instanceof MediaEntry) {
                    MediaEntry me = (MediaEntry)parentElement;
                    IMediaContainer mediaManager = MediaFactory.mount((File)me.getUserObject());
                    entries = mediaManager.getEntries(parentElement);
                }
            }
            return entries;
        }

        public Object getParent(Object element) {
            Object parent = null;
            if (element instanceof Project) {
                return null;
            }
            if (element instanceof ProjectFolder) {
                return null;
            }
            if (element instanceof File) {
                File file = (File)element;
                parent = file.getParentFile();
            } else if (element instanceof MediaEntry) {
                MediaEntry me = (MediaEntry)element;
                parent = me.isRoot() ? me.getUserObject() : me.getParent();
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            boolean hasChildren = false;
            if (element instanceof Project) {
                boolean bl = hasChildren = !((Project)element).isSingleFileProject() || ((Project)element).isMountpoint();
            }
            if (element instanceof ProjectFolder) {
                hasChildren = true;
            } else if (element instanceof File) {
                File file = (File)element;
                hasChildren = file.isDirectory() ? true : MediaFactory.isMountable(file);
            } else if (element instanceof MediaEntry) {
                MediaEntry me = (MediaEntry)element;
                hasChildren = me.isDirectory();
            }
            return hasChildren;
        }
    }
}

