/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.enums;

public enum ProjectType {
    CharSet("CHARSET", "ns_chr", "icons/chr.png"),
    SpriteSet("SPRITESET", "ns_spr", "icons/spr.png"),
    ScreenSet("SCREENSET", "ns_scr", "icons/scr.png"),
    PETSCII("PETSCII", "ns_scr", "icons/scr.png"),
    TileMap("TILEMAP", "ns_tm", "icons/tm.png"),
    TileSet("TILESET", "ns_ts", "icons/ts.png"),
    Assembler("ASSEMBLER", "asm", "icons/asm.png"),
    Basic("BASIC", "bas", "icons/bas.png"),
    MountPoint("MOUNT_POINT", null, "icons/disk.png");

    private String id;
    private String suffix;
    private String iconName;

    private ProjectType(String id, String suffix, String iconName) {
        this.id = id;
        this.suffix = suffix;
        this.iconName = iconName;
    }

    public static ProjectType getProjectTypeById(String id) {
        ProjectType result = null;
        ProjectType[] projectTypeArray = ProjectType.values();
        int n = projectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectType pt = projectTypeArray[n2];
            if (pt.getId().equalsIgnoreCase(id)) {
                result = pt;
                break;
            }
            ++n2;
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getIconName() {
        return this.iconName;
    }
}

