/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu.platform;

import de.drazil.nerdsuite.cpu.CPU_Z80;
import de.drazil.nerdsuite.cpu.decode.dialect.IDialect;
import de.drazil.nerdsuite.cpu.platform.AbstractPlatform;
import de.drazil.nerdsuite.model.Address;
import de.drazil.nerdsuite.model.BasicInstructions;
import de.drazil.nerdsuite.model.DisassemblingRange;
import de.drazil.nerdsuite.model.Value;
import de.drazil.nerdsuite.widget.IContentProvider;
import java.util.List;

public class CPC6128Platform
extends AbstractPlatform {
    private BasicInstructions basicInstructions;

    public CPC6128Platform(IDialect dialect, boolean ignoreStartAddressBytes) {
        super(dialect, new CPU_Z80(), ignoreStartAddressBytes, "configuration/platform/cpc6128_platform.json");
    }

    @Override
    public boolean supportsSpecialStartSequence() {
        return true;
    }

    @Override
    public boolean supportsBasic() {
        return false;
    }

    @Override
    public void handlePlatformSpecific(byte[] byteArray, int offset) {
    }

    @Override
    public void handleAddress(Address address, Value value) {
    }

    @Override
    public void parseStartSequence(byte[] byteArray, Value programCounter) {
    }

    @Override
    public void parseBinary(IContentProvider contentProvider, List<DisassemblingRange> ranges) {
        block6: {
            System.out.println("init   : build memory map");
            this.setProgrammCounter(this.getProgrammCounter());
            this.init(contentProvider);
            System.out.println("stage 2: parse instructions");
            long start = System.currentTimeMillis();
            try {
                try {
                    for (DisassemblingRange dr : ranges) {
                        this.getCPU().decode(contentProvider, this.getProgrammCounter(), this.getPlatFormData(), dr, 2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.printf("line: %d\n", this.getCPU().getLine());
                    System.out.printf("%d ms\n", System.currentTimeMillis() - start);
                    System.out.println("ready.");
                    break block6;
                }
            }
            catch (Throwable throwable) {
                System.out.printf("line: %d\n", this.getCPU().getLine());
                System.out.printf("%d ms\n", System.currentTimeMillis() - start);
                System.out.println("ready.");
                throw throwable;
            }
            System.out.printf("line: %d\n", this.getCPU().getLine());
            System.out.printf("%d ms\n", System.currentTimeMillis() - start);
            System.out.println("ready.");
        }
    }
}

