/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu.platform;

import de.drazil.nerdsuite.cpu.CPU_6510;
import de.drazil.nerdsuite.cpu.decode.InstructionLine;
import de.drazil.nerdsuite.cpu.decode.dialect.IDialect;
import de.drazil.nerdsuite.cpu.platform.AbstractPlatform;
import de.drazil.nerdsuite.model.Address;
import de.drazil.nerdsuite.model.DisassemblingRange;
import de.drazil.nerdsuite.model.InstructionType;
import de.drazil.nerdsuite.model.Value;
import de.drazil.nerdsuite.widget.IContentProvider;
import java.util.List;

public class C64Platform
extends AbstractPlatform {
    public C64Platform(IDialect dialect, boolean ignoreStartAddressBytes) {
        super(dialect, new CPU_6510(), ignoreStartAddressBytes, "configuration/platform/c64_platform.json");
    }

    @Override
    public boolean supportsBasic() {
        return true;
    }

    @Override
    public boolean supportsSpecialStartSequence() {
        return true;
    }

    @Override
    public void handlePlatformSpecific(byte[] byteArray, int offset) {
    }

    @Override
    public void handleAddress(Address address, Value value) {
    }

    @Override
    public void parseStartSequence(byte[] byteArray, Value programCounter) {
        if (programCounter.getValue() == 2049) {
            InstructionLine instructionLine = this.getCPU().getInstructionLineList().get(0);
            instructionLine.setPassed(true);
            instructionLine.setInstructionType(InstructionType.Basic);
        }
    }

    @Override
    public void parseBinary(IContentProvider contentProvider, List<DisassemblingRange> ranges) {
        System.out.println("init   : build memory map");
        this.setProgrammCounter(this.getProgrammCounter());
        this.init(contentProvider);
        System.out.println("stage 1: parse header information");
        this.parseStartSequence(contentProvider.getContentArray(), this.getProgrammCounter());
        System.out.println("stage 2: parse instructions");
        long start = System.currentTimeMillis();
        for (DisassemblingRange dr : ranges) {
            this.getCPU().decode(contentProvider, this.getProgrammCounter(), this.getPlatFormData(), dr, 2);
        }
        long duration = System.currentTimeMillis() - start;
        System.out.printf("%d Seconds", duration);
        System.out.println("ready.");
    }
}

