/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu.platform;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.drazil.nerdsuite.basic.decode.BasicParser;
import de.drazil.nerdsuite.cpu.ICPU;
import de.drazil.nerdsuite.cpu.InstructionSet;
import de.drazil.nerdsuite.cpu.decode.InstructionLine;
import de.drazil.nerdsuite.cpu.decode.dialect.IDialect;
import de.drazil.nerdsuite.cpu.platform.IPlatform;
import de.drazil.nerdsuite.model.BasicInstruction;
import de.drazil.nerdsuite.model.BasicInstructions;
import de.drazil.nerdsuite.model.InstructionType;
import de.drazil.nerdsuite.model.PlatformData;
import de.drazil.nerdsuite.model.Range;
import de.drazil.nerdsuite.model.ReferenceType;
import de.drazil.nerdsuite.model.Value;
import de.drazil.nerdsuite.widget.IContentProvider;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public abstract class AbstractPlatform
implements IPlatform {
    private IDialect dialect;
    private boolean ignoreStartAddressBytes = false;
    private boolean supportsBasic = false;
    private ICPU cpu;
    private PlatformData platformData;
    private BasicParser basicParser;
    private BasicInstructions basicInstructions;
    private Value pc;

    public AbstractPlatform(IDialect dialect, ICPU cpu, boolean ignoreStartAddressBytes, String addressFileName) {
        this.setDialect(dialect);
        this.setCPU(cpu);
        this.setIgnoreStartAddressBytes(ignoreStartAddressBytes);
        this.readPlatformData(addressFileName);
        this.readBasicTokens();
    }

    @Override
    public IDialect getDialect() {
        return this.dialect;
    }

    @Override
    public void setDialect(IDialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public boolean isIgnoreStartAddressBytes() {
        return this.ignoreStartAddressBytes;
    }

    @Override
    public void setIgnoreStartAddressBytes(boolean ignoreStartAddressBytes) {
        this.ignoreStartAddressBytes = ignoreStartAddressBytes;
    }

    @Override
    public ICPU getCPU() {
        return this.cpu;
    }

    @Override
    public void setCPU(ICPU cpu) {
        this.cpu = cpu;
    }

    @Override
    public void init(IContentProvider contentProvider) {
        this.getCPU().addInstructionLine(new InstructionLine(this.getProgrammCounter(), new Range(0, contentProvider.getContentLength()), InstructionType.Undefined, ReferenceType.NoReference));
    }

    @Override
    public Value getProgrammCounter() {
        return this.pc;
    }

    @Override
    public void setProgrammCounter(Value pc) {
        this.pc = pc;
    }

    @Override
    public PlatformData getPlatFormData() {
        return this.platformData;
    }

    private void readBasicTokens() {
        String basicInstructionSource = this.platformData.getBasicInstructionSource();
        if (basicInstructionSource != null && this.supportsBasic()) {
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, BasicInstruction> basicTokenMap = new HashMap<String, BasicInstruction>();
            try {
                System.out.printf("read basic instructions from : %s", basicInstructionSource);
                Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
                URL url = bundle.getEntry(basicInstructionSource);
                File file = new File(FileLocator.resolve((URL)url).toURI());
                this.basicInstructions = (BasicInstructions)mapper.readValue(file, BasicInstructions.class);
                for (BasicInstruction object2 : this.basicInstructions.getBasicInstructionList()) {
                }
                BasicParser basicParser = new BasicParser(this.getProgrammCounter(), this.getCPU(), basicTokenMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void readPlatformData(String fileName) {
        try {
            Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
            ObjectMapper mapper = new ObjectMapper();
            this.platformData = (PlatformData)mapper.readValue(bundle.getEntry(fileName), PlatformData.class);
            InstructionSet.init(this.platformData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Value checkAdress(byte[] content, int start) {
        Value value = new Value(0);
        List<String> commonStartAdress = this.getPlatFormData().getCommonStartAdresses();
        if (commonStartAdress != null) {
            for (String address : commonStartAdress) {
                int adr = Integer.parseInt(address, 16);
                if (adr != this.getCPU().getWord(content, start)) continue;
                value = new Value(adr);
                break;
            }
        }
        return value;
    }
}

