/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu.emulate;

import de.drazil.nerdsuite.cpu.emulate.AbstractCPU;
import de.drazil.nerdsuite.cpu.emulate.IPlatform;

public class CPU6510
extends AbstractCPU {
    public static final int FLAG_CARRY = 0;
    public static final int FLAG_ZERO = 1;
    public static final int FLAG_INTERRUPT = 2;
    public static final int FLAG_DECIMAL = 4;
    public static final int FLAG_BREAK = 8;
    public static final int FLAG_EXPANSION = 16;
    public static final int FLAG_OVERFLOW = 32;
    public static final int FLAG_NEGATIVE = 64;
    public static final int REG_SP = 1;
    public static final int REG_PC = 2;
    public static final int REG_A = 3;
    public static final int REG_X = 4;
    public static final int REG_Y = 5;
    public static final int REG_PP = 6;
    public static final int REG_DD = 7;

    public CPU6510(IPlatform platform) {
        super(platform);
    }

    @Override
    public int execute(int pc, boolean debug) {
        int[] ram = this.getPlatform().getRAM();
        int[] rom = this.getPlatform().getROM();
        int instruction = ram[pc];
        switch (instruction) {
            case 0: {
                ++pc;
                this.setFlag(8, true);
                this.setFlag(2, true);
                this.stack.push(++pc);
                this.stack.push(this.registers[0]);
                pc = (ram[65534] & 0xFF) + (ram[65535] << 8) & 0xFF00;
                break;
            }
            case 1: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[3] = this.registers[3] | ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[3] = this.registers[3] | ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 6: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.setFlag(0, (ram[adr] & 0x80) == 128);
                int n = adr;
                ram[n] = ram[n] << 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 2;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.stack.push(this.registers[0]);
                ++pc;
                break;
            }
            case 9: {
                this.registers[3] = this.registers[3] | (byte)this.getValue(pc + 1, ram, rom);
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 10: {
                this.setFlag(0, (this.registers[3] & 0x80) == 128);
                this.registers[3] = this.registers[3] << 1;
                this.setNegativeFlag(this.registers[3]);
                this.setZeroFlag(this.registers[3]);
                ++pc;
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[3] = this.registers[3] | ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 14: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.setFlag(0, (ram[adr] & 0x80) == 128);
                int n = adr;
                ram[n] = ram[n] << 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 3;
                break;
            }
            case 15: 
            case 16: {
                if (this.hasFlag(64)) break;
                pc += (ram[pc + 1] & 0x80) == 128 ? -(ram[pc + 1] & 0x7F) : ram[pc + 1] & 0x7F;
                break;
            }
            case 17: {
                int adr = this.getAddress(pc + 1, ram, rom, 0) + this.registers[5];
                adr = this.getAddress(adr, ram, rom, 0);
                this.registers[3] = this.registers[3] | ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[3] = this.registers[3] | ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 22: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.setFlag(0, (ram[adr] & 0x80) == 128);
                int n = adr;
                ram[n] = ram[n] << 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 2;
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                this.registers[0] = this.registers[0] & 0xFFFFFFFF;
                ++pc;
                break;
            }
            case 25: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[5]);
                this.registers[3] = this.registers[3] | ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[3] = this.registers[3] | ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 30: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.setFlag(0, (ram[adr] & 0x80) == 128);
                int n = adr;
                ram[n] = ram[n] << 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 3;
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.stack.push(pc += 3);
                break;
            }
            case 33: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[3] = this.registers[3] & ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                break;
            }
            case 37: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[3] = this.registers[3] & ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 38: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.setFlag(0, (ram[adr] & 0x80) == 128);
                int n = adr;
                ram[n] = ram[n] << 1;
                if (this.hasFlag(0)) {
                    int n2 = adr;
                    ram[n2] = ram[n2] & 1;
                }
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 2;
                break;
            }
            case 39: {
                break;
            }
            case 40: {
                this.registers[0] = (Integer)this.stack.pop();
                ++pc;
                break;
            }
            case 41: {
                int v = this.getValue(pc + 1, ram, rom);
                this.registers[3] = this.registers[3] & v;
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 42: {
                this.setFlag(0, (this.registers[3] & 0x80) == 128);
                this.registers[3] = this.registers[3] << 1;
                if (this.hasFlag(0)) {
                    this.registers[3] = this.registers[3] & 1;
                }
                this.setNegativeFlag(this.registers[3]);
                this.setZeroFlag(this.registers[3]);
                ++pc;
                break;
            }
            case 43: {
                break;
            }
            case 44: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                break;
            }
            case 45: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[3] = this.registers[3] & ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 46: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.setFlag(0, (ram[adr] & 0x80) == 128);
                int n = adr;
                ram[n] = ram[n] << 1;
                if (this.hasFlag(0)) {
                    int n3 = adr;
                    ram[n3] = ram[n3] & 1;
                }
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 3;
                break;
            }
            case 47: {
                break;
            }
            case 48: {
                if (!this.hasFlag(64)) break;
                pc += (ram[pc + 1] & 0x80) == 128 ? -(ram[pc + 1] & 0x7F) : ram[pc + 1] & 0x7F;
                break;
            }
            case 49: {
                int adr = this.getAddress(pc + 1, ram, rom, 0) + this.registers[5];
                adr = this.getAddress(adr, ram, rom, 0);
                this.registers[3] = this.registers[3] & ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 50: {
                break;
            }
            case 51: {
                break;
            }
            case 52: {
                break;
            }
            case 53: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[3] = this.registers[3] & ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 54: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.setFlag(0, (ram[adr] & 0x80) == 128);
                int n = adr;
                ram[n] = ram[n] << 1;
                if (this.hasFlag(0)) {
                    int n4 = adr;
                    ram[n4] = ram[n4] & 1;
                }
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 2;
                break;
            }
            case 55: {
                break;
            }
            case 56: {
                this.registers[0] = this.registers[0] | 0;
                ++pc;
                break;
            }
            case 57: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[5]);
                this.registers[3] = this.registers[3] & ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 58: {
                break;
            }
            case 59: {
                break;
            }
            case 60: {
                break;
            }
            case 61: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[3] = this.registers[3] & ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 62: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.setFlag(0, (ram[adr] & 0x80) == 128);
                int n = adr;
                ram[n] = ram[n] << 1;
                if (this.hasFlag(0)) {
                    int n5 = adr;
                    ram[n5] = ram[n5] & 1;
                }
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 2;
                break;
            }
            case 63: {
                break;
            }
            case 64: {
                break;
            }
            case 65: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[3] = this.registers[3] ^ ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 66: {
                break;
            }
            case 67: {
                break;
            }
            case 68: {
                break;
            }
            case 69: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[3] = this.registers[3] ^ ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 70: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.setFlag(0, (ram[adr] & 1) == 1);
                int n = adr;
                ram[n] = ram[n] >> 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 2;
                break;
            }
            case 71: {
                break;
            }
            case 72: {
                this.stack.push(this.registers[3]);
                ++pc;
                break;
            }
            case 73: {
                int v = this.getValue(pc + 1, ram, rom);
                this.registers[3] = this.registers[3] ^ v;
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 74: {
                this.setFlag(0, (this.registers[3] & 1) == 1);
                this.registers[3] = this.registers[3] >> 1;
                this.setNegativeFlag(this.registers[3]);
                this.setZeroFlag(this.registers[3]);
                ++pc;
                break;
            }
            case 75: {
                break;
            }
            case 76: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                break;
            }
            case 77: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[3] = this.registers[3] ^ ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 78: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.setFlag(0, (ram[adr] & 1) == 1);
                int n = adr;
                ram[n] = ram[n] >> 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 3;
                break;
            }
            case 79: {
                break;
            }
            case 80: {
                this.hasFlag(32);
                pc += 2;
                break;
            }
            case 81: {
                int adr = this.getAddress(pc + 1, ram, rom, 0) + this.registers[5];
                adr = this.getAddress(adr, ram, rom, 0);
                this.registers[3] = this.registers[3] & ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 82: {
                break;
            }
            case 83: {
                break;
            }
            case 84: {
                break;
            }
            case 85: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[3] = this.registers[3] ^ ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 86: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.setFlag(0, (ram[adr] & 1) == 1);
                int n = adr;
                ram[n] = ram[n] >> 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 2;
                break;
            }
            case 87: {
                break;
            }
            case 88: {
                this.registers[0] = this.registers[0] & 0xFFFFFFFD;
                ++pc;
                break;
            }
            case 89: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[5]);
                this.registers[3] = this.registers[3] ^ ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 90: {
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                break;
            }
            case 93: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[3] = this.registers[3] ^ ram[adr];
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 94: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.setFlag(0, (ram[adr] & 1) == 1);
                int n = adr;
                ram[n] = ram[n] >> 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 3;
                break;
            }
            case 95: {
                break;
            }
            case 96: {
                pc = (Integer)this.stack.pop();
                break;
            }
            case 97: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_m + lo_a + (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0xFF) > 9) {
                        lo += 6;
                    }
                    if (((hi = hi_m + hi_a + (lo > 15 ? 1 : 0)) & 0xFF) > 9) {
                        hi += 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi > 15);
                } else {
                    this.registers[3] = this.registers[3] + (ram[adr] + (this.hasFlag(0) ? 1 : 0));
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 98: {
                break;
            }
            case 99: {
                break;
            }
            case 100: {
                break;
            }
            case 101: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_m + lo_a + (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0xFF) > 9) {
                        lo += 6;
                    }
                    if (((hi = hi_m + hi_a + (lo > 15 ? 1 : 0)) & 0xFF) > 9) {
                        hi += 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi > 15);
                } else {
                    this.registers[3] = this.registers[3] + (ram[adr] + (this.hasFlag(0) ? 1 : 0));
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 102: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.setFlag(0, (ram[adr] & 1) == 1);
                int n = adr;
                ram[n] = ram[n] >> 1;
                if (this.hasFlag(0)) {
                    int n6 = adr;
                    ram[n6] = ram[n6] & 0x80;
                }
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 2;
                break;
            }
            case 103: {
                break;
            }
            case 104: {
                this.registers[3] = (Integer)this.stack.pop();
                ++pc;
                break;
            }
            case 105: {
                int v = this.getValue(pc + 1, ram, rom);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = v & 0xF;
                    int hi_m = v >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_m + lo_a + (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0xFF) > 9) {
                        lo += 6;
                    }
                    if (((hi = hi_m + hi_a + (lo > 15 ? 1 : 0)) & 0xFF) > 9) {
                        hi += 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi > 15);
                } else {
                    this.registers[3] = this.registers[3] + (v + (this.hasFlag(0) ? 1 : 0));
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 106: {
                this.setFlag(0, (this.registers[3] & 1) == 1);
                this.registers[3] = this.registers[3] >> 1;
                if (this.hasFlag(0)) {
                    this.registers[3] = this.registers[3] & 0x80;
                }
                this.setNegativeFlag(this.registers[3]);
                this.setZeroFlag(this.registers[3]);
                ++pc;
                break;
            }
            case 107: {
                break;
            }
            case 108: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                break;
            }
            case 109: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_m + lo_a + (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0xFF) > 9) {
                        lo += 6;
                    }
                    if (((hi = hi_m + hi_a + (lo > 15 ? 1 : 0)) & 0xFF) > 9) {
                        hi += 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi > 15);
                } else {
                    this.registers[3] = this.registers[3] + (ram[adr] + (this.hasFlag(0) ? 1 : 0));
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 110: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.setFlag(0, (ram[adr] & 1) == 1);
                int n = adr;
                ram[n] = ram[n] >> 1;
                if (this.hasFlag(0)) {
                    int n7 = adr;
                    ram[n7] = ram[n7] & 0x80;
                }
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 2;
                break;
            }
            case 111: {
                break;
            }
            case 112: {
                this.hasFlag(32);
                pc += 2;
                break;
            }
            case 113: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_m + lo_a + (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0xFF) > 9) {
                        lo += 6;
                    }
                    if (((hi = hi_m + hi_a + (lo > 15 ? 1 : 0)) & 0xFF) > 9) {
                        hi += 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi > 15);
                } else {
                    this.registers[3] = this.registers[3] + (ram[adr] + (this.hasFlag(0) ? 1 : 0));
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 114: {
                break;
            }
            case 115: {
                break;
            }
            case 116: {
                break;
            }
            case 117: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_m + lo_a + (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0xFF) > 9) {
                        lo += 6;
                    }
                    if (((hi = hi_m + hi_a + (lo > 15 ? 1 : 0)) & 0xFF) > 9) {
                        hi += 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi > 15);
                } else {
                    this.registers[3] = this.registers[3] + (ram[adr] + (this.hasFlag(0) ? 1 : 0));
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 118: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.setFlag(0, (ram[adr] & 1) == 1);
                int n = adr;
                ram[n] = ram[n] >> 1;
                if (this.hasFlag(0)) {
                    int n8 = adr;
                    ram[n8] = ram[n8] & 0x80;
                }
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 2;
                break;
            }
            case 119: {
                break;
            }
            case 120: {
                this.registers[0] = this.registers[0] | 2;
                break;
            }
            case 121: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[5]);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_m + lo_a + (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0xFF) > 9) {
                        lo += 6;
                    }
                    if (((hi = hi_m + hi_a + (lo > 15 ? 1 : 0)) & 0xFF) > 9) {
                        hi += 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi > 15);
                } else {
                    this.registers[3] = this.registers[3] + (ram[adr] + (this.hasFlag(0) ? 1 : 0));
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 122: {
                break;
            }
            case 123: {
                break;
            }
            case 124: {
                break;
            }
            case 125: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_m + lo_a + (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0xFF) > 9) {
                        lo += 6;
                    }
                    if (((hi = hi_m + hi_a + (lo > 15 ? 1 : 0)) & 0xFF) > 9) {
                        hi += 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi > 15);
                } else {
                    this.registers[3] = this.registers[3] + (ram[adr] + (this.hasFlag(0) ? 1 : 0));
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 126: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.setFlag(0, (ram[adr] & 1) == 1);
                int n = adr;
                ram[n] = ram[n] >> 1;
                if (this.hasFlag(0)) {
                    int n9 = adr;
                    ram[n9] = ram[n9] & 0x80;
                }
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                pc += 3;
                break;
            }
            case 127: {
                break;
            }
            case 128: {
                break;
            }
            case 129: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                ram[adr] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 130: {
                break;
            }
            case 131: {
                break;
            }
            case 132: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                ram[adr] = this.registers[5] & 0xFF;
                pc += 2;
                break;
            }
            case 133: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                ram[adr] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 134: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                ram[adr] = this.registers[4] & 0xFF;
                pc += 2;
                break;
            }
            case 135: {
                break;
            }
            case 136: {
                this.registers[5] = this.registers[5] + 1;
                this.setNegativeFlag(this.registers[5]);
                this.setZeroFlag(this.registers[5]);
                this.registers[5] = this.registers[5] & 0xFF;
                ++pc;
                break;
            }
            case 137: {
                break;
            }
            case 138: {
                this.registers[3] = this.registers[4];
                ++pc;
                break;
            }
            case 139: {
                break;
            }
            case 140: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                ram[adr] = this.registers[5] & 0xFF;
                pc += 2;
                break;
            }
            case 141: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                ram[adr] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 142: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                ram[adr] = this.registers[4] & 0xFF;
                pc += 2;
                break;
            }
            case 143: {
                break;
            }
            case 144: {
                if (this.hasFlag(0)) break;
                pc += (ram[pc + 1] & 0x80) == 128 ? -(ram[pc + 1] & 0x7F) : ram[pc + 1] & 0x7F;
                break;
            }
            case 145: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                ram[adr] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 146: {
                break;
            }
            case 147: {
                break;
            }
            case 148: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                ram[adr] = this.registers[5] & 0xFF;
                pc += 2;
                break;
            }
            case 149: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                ram[adr] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 150: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[5]);
                ram[adr] = this.registers[4] & 0xFF;
                pc += 2;
                break;
            }
            case 151: {
                break;
            }
            case 152: {
                this.registers[3] = this.registers[5];
                ++pc;
                break;
            }
            case 153: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[5]);
                break;
            }
            case 154: {
                this.registers[1] = this.registers[4];
                ++pc;
                break;
            }
            case 155: {
                break;
            }
            case 156: {
                break;
            }
            case 157: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                ram[adr] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 158: {
                break;
            }
            case 159: {
                break;
            }
            case 160: {
                int v = this.getValue(pc + 1, ram, rom);
                this.registers[5] = v & 0xFF;
                this.setNegativeFlag(this.registers[5]);
                this.setZeroFlag(this.registers[5]);
                this.registers[5] = this.registers[5] & 0xFF;
                pc += 2;
                break;
            }
            case 161: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[3] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[3]);
                this.setZeroFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 162: {
                int v = this.getValue(pc + 1, ram, rom);
                this.registers[4] = v & 0xFF;
                this.setNegativeFlag(this.registers[4]);
                this.setZeroFlag(this.registers[4]);
                this.registers[4] = this.registers[4] & 0xFF;
                pc += 2;
                break;
            }
            case 163: {
                break;
            }
            case 164: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[5] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[5]);
                this.setZeroFlag(this.registers[5]);
                this.registers[5] = this.registers[5] & 0xFF;
                pc += 2;
                break;
            }
            case 165: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[3] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[3]);
                this.setZeroFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 166: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[4] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[4]);
                this.setZeroFlag(this.registers[4]);
                this.registers[4] = this.registers[4] & 0xFF;
                pc += 2;
                break;
            }
            case 167: {
                break;
            }
            case 168: {
                this.registers[5] = this.registers[3];
                ++pc;
                break;
            }
            case 169: {
                int v = this.getValue(pc + 1, ram, rom);
                this.registers[3] = v & 0xFF;
                this.setNegativeFlag(this.registers[3]);
                this.setZeroFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 170: {
                this.registers[4] = this.registers[3];
                ++pc;
                break;
            }
            case 171: {
                break;
            }
            case 172: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[5] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[5]);
                this.setZeroFlag(this.registers[5]);
                this.registers[5] = this.registers[5] & 0xFF;
                pc += 3;
                break;
            }
            case 173: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[3] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[3]);
                this.setZeroFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 174: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[4] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[4]);
                this.setZeroFlag(this.registers[4]);
                this.registers[4] = this.registers[4] & 0xFF;
                pc += 3;
                break;
            }
            case 175: {
                break;
            }
            case 176: {
                if (!this.hasFlag(0)) break;
                pc += (ram[pc + 1] & 0x80) == 128 ? -(ram[pc + 1] & 0x7F) : ram[pc + 1] & 0x7F;
                break;
            }
            case 177: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                this.registers[3] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[3]);
                this.setZeroFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 178: {
                break;
            }
            case 179: {
                break;
            }
            case 180: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[5] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[5]);
                this.setZeroFlag(this.registers[5]);
                this.registers[5] = this.registers[5] & 0xFF;
                pc += 2;
                break;
            }
            case 181: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[3] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[3]);
                this.setZeroFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 182: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[5]);
                this.registers[4] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[4]);
                this.setZeroFlag(this.registers[4]);
                this.registers[4] = this.registers[4] & 0xFF;
                pc += 2;
                break;
            }
            case 183: {
                break;
            }
            case 184: {
                this.registers[0] = this.registers[0] & 0xFFFFFFDF;
                ++pc;
                break;
            }
            case 185: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[5]);
                this.registers[3] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[3]);
                this.setZeroFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 186: {
                this.registers[4] = this.registers[1];
                ++pc;
                break;
            }
            case 187: {
                break;
            }
            case 188: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[5] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[5]);
                this.setZeroFlag(this.registers[5]);
                this.registers[5] = this.registers[5] & 0xFF;
                pc += 3;
                break;
            }
            case 189: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                this.registers[3] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[3]);
                this.setZeroFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 190: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[5]);
                this.registers[4] = ram[adr] & 0xFF;
                this.setNegativeFlag(this.registers[4]);
                this.setZeroFlag(this.registers[4]);
                this.registers[4] = this.registers[4] & 0xFF;
                pc += 3;
                break;
            }
            case 191: {
                break;
            }
            case 192: {
                int v = this.getValue(pc + 1, ram, rom);
                int res = this.registers[5] - v;
                this.setCompareStatus(res);
                pc += 2;
                break;
            }
            case 193: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                int res = this.registers[3] - ram[adr];
                this.setCompareStatus(res);
                pc += 2;
                break;
            }
            case 194: {
                break;
            }
            case 195: {
                break;
            }
            case 196: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                int res = this.registers[5] - ram[adr];
                this.setCompareStatus(res);
                pc += 2;
                break;
            }
            case 197: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                int res = this.registers[3] - ram[adr];
                this.setCompareStatus(res);
                pc += 2;
                break;
            }
            case 198: {
                int adr;
                int n = adr = this.getAddress(pc + 1, ram, rom, 0);
                ram[n] = ram[n] - 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                int n10 = adr;
                ram[n10] = ram[n10] & 0xFF;
                pc += 2;
                break;
            }
            case 199: {
                break;
            }
            case 200: {
                this.registers[5] = this.registers[5] + 1;
                this.setNegativeFlag(this.registers[5]);
                this.setZeroFlag(this.registers[5]);
                this.registers[5] = this.registers[5] & 0xFF;
                ++pc;
                break;
            }
            case 201: {
                int v = this.getValue(pc + 1, ram, rom);
                int res = this.registers[3] - v;
                this.setCompareStatus(res);
                pc += 2;
                break;
            }
            case 202: {
                this.registers[4] = this.registers[4] - 1;
                this.setNegativeFlag(this.registers[4]);
                this.setZeroFlag(this.registers[4]);
                this.registers[4] = this.registers[4] & 0xFF;
                ++pc;
                break;
            }
            case 203: {
                break;
            }
            case 204: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                int res = this.registers[5] - ram[adr];
                this.setCompareStatus(res);
                pc += 3;
                break;
            }
            case 205: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                int res = this.registers[3] - ram[adr];
                this.setCompareStatus(res);
                pc += 3;
                break;
            }
            case 206: {
                int adr;
                int n = adr = this.getAddress(pc + 1, ram, rom, 0);
                ram[n] = ram[n] - 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                int n11 = adr;
                ram[n11] = ram[n11] & 0xFF;
                pc += 3;
                break;
            }
            case 207: {
                break;
            }
            case 208: {
                this.hasFlag(1);
                pc += 2;
                break;
            }
            case 209: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                int res = this.registers[5] - ram[adr];
                this.setCompareStatus(res);
                pc += 2;
                break;
            }
            case 210: {
                break;
            }
            case 211: {
                break;
            }
            case 212: {
                break;
            }
            case 213: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                int res = this.registers[3] - ram[adr];
                this.setCompareStatus(res);
                pc += 2;
                break;
            }
            case 214: {
                int adr;
                int n = adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                ram[n] = ram[n] - 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                int n12 = adr;
                ram[n12] = ram[n12] & 0xFF;
                pc += 2;
                break;
            }
            case 215: {
                break;
            }
            case 216: {
                this.registers[0] = this.registers[0] & 0xFFFFFFFB;
                ++pc;
                break;
            }
            case 217: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[5]);
                int res = this.registers[3] - ram[adr];
                this.setCompareStatus(res);
                pc += 3;
                break;
            }
            case 218: {
                break;
            }
            case 219: {
                break;
            }
            case 220: {
                break;
            }
            case 221: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                int res = this.registers[3] - ram[adr];
                this.setCompareStatus(res);
                pc += 3;
                break;
            }
            case 222: {
                int adr;
                int n = adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                ram[n] = ram[n] - 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                int n13 = adr;
                ram[n13] = ram[n13] & 0xFF;
                pc += 2;
                break;
            }
            case 223: {
                break;
            }
            case 224: {
                int v = this.getValue(pc + 1, ram, rom);
                int res = this.registers[4] - v;
                this.setCompareStatus(res);
                pc += 2;
                break;
            }
            case 225: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_a - lo_m - (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0x10) != 0) {
                        lo -= 6;
                    }
                    if (((hi = hi_a - hi_m - ((lo & 0x10) != 0 ? 1 : 0)) & 0x10) != 0) {
                        hi -= 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi < 15);
                } else {
                    this.registers[3] = this.registers[3] - ram[adr];
                    if (this.hasFlag(0)) {
                        this.registers[3] = this.registers[3] + 1;
                    }
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 226: {
                break;
            }
            case 227: {
                break;
            }
            case 228: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                int res = this.registers[4] - ram[adr];
                this.setCompareStatus(res);
                pc += 2;
                break;
            }
            case 229: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_a - lo_m - (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0x10) != 0) {
                        lo -= 6;
                    }
                    if (((hi = hi_a - hi_m - ((lo & 0x10) != 0 ? 1 : 0)) & 0x10) != 0) {
                        hi -= 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi < 15);
                } else {
                    this.registers[3] = this.registers[3] - ram[adr];
                    if (this.hasFlag(0)) {
                        this.registers[3] = this.registers[3] + 1;
                    }
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 230: {
                int adr;
                int n = adr = this.getAddress(pc + 1, ram, rom, 0);
                ram[n] = ram[n] + 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                int n14 = adr;
                ram[n14] = ram[n14] & 0xFF;
                pc += 2;
                break;
            }
            case 231: {
                break;
            }
            case 232: {
                this.registers[4] = this.registers[4] + 1;
                this.setNegativeFlag(this.registers[4]);
                this.setZeroFlag(this.registers[4]);
                this.registers[4] = this.registers[4] & 0xFF;
                ++pc;
                break;
            }
            case 233: {
                int v = this.getValue(pc + 1, ram, rom);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = v & 0xF;
                    int hi_m = v >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_a - lo_m - (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0x10) != 0) {
                        lo -= 6;
                    }
                    if (((hi = hi_a - hi_m - ((lo & 0x10) != 0 ? 1 : 0)) & 0x10) != 0) {
                        hi -= 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi < 15);
                } else {
                    this.registers[3] = this.registers[3] - v;
                    if (this.hasFlag(0)) {
                        this.registers[3] = this.registers[3] + 1;
                    }
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 234: {
                break;
            }
            case 235: {
                break;
            }
            case 236: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                int res = this.registers[4] - ram[adr];
                this.setCompareStatus(res);
                pc += 3;
                break;
            }
            case 237: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_a - lo_m - (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0x10) != 0) {
                        lo -= 6;
                    }
                    if (((hi = hi_a - hi_m - ((lo & 0x10) != 0 ? 1 : 0)) & 0x10) != 0) {
                        hi -= 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi < 15);
                } else {
                    this.registers[3] = this.registers[3] - ram[adr];
                    if (this.hasFlag(0)) {
                        this.registers[3] = this.registers[3] + 1;
                    }
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 238: {
                int adr;
                int n = adr = this.getAddress(pc + 1, ram, rom, 0);
                ram[n] = ram[n] + 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                int n15 = adr;
                ram[n15] = ram[n15] & 0xFF;
                pc += 3;
                break;
            }
            case 239: {
                break;
            }
            case 240: {
                if (!this.hasFlag(1)) break;
                pc += (ram[pc + 1] & 0x80) == 128 ? -(ram[pc + 1] & 0x7F) : ram[pc + 1] & 0x7F;
                break;
            }
            case 241: {
                int adr = this.getAddress(pc + 1, ram, rom, 0);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_a - lo_m - (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0x10) != 0) {
                        lo -= 6;
                    }
                    if (((hi = hi_a - hi_m - ((lo & 0x10) != 0 ? 1 : 0)) & 0x10) != 0) {
                        hi -= 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi < 15);
                } else {
                    this.registers[3] = this.registers[3] - ram[adr];
                    if (this.hasFlag(0)) {
                        this.registers[3] = this.registers[3] + 1;
                    }
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 242: {
                break;
            }
            case 243: {
                break;
            }
            case 244: {
                break;
            }
            case 245: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_a - lo_m - (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0x10) != 0) {
                        lo -= 6;
                    }
                    if (((hi = hi_a - hi_m - ((lo & 0x10) != 0 ? 1 : 0)) & 0x10) != 0) {
                        hi -= 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi < 15);
                } else {
                    this.registers[3] = this.registers[3] - ram[adr];
                    if (this.hasFlag(0)) {
                        this.registers[3] = this.registers[3] + 1;
                    }
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 2;
                break;
            }
            case 246: {
                int adr;
                int n = adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                ram[n] = ram[n] + 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                int n16 = adr;
                ram[n16] = ram[n16] & 0xFF;
                pc += 2;
                break;
            }
            case 247: {
                break;
            }
            case 248: {
                this.registers[0] = this.registers[0] | 4;
                ++pc;
                break;
            }
            case 249: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[5]);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_a - lo_m - (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0x10) != 0) {
                        lo -= 6;
                    }
                    if (((hi = hi_a - hi_m - ((lo & 0x10) != 0 ? 1 : 0)) & 0x10) != 0) {
                        hi -= 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi < 15);
                } else {
                    this.registers[3] = this.registers[3] - ram[adr];
                    if (this.hasFlag(0)) {
                        this.registers[3] = this.registers[3] + 1;
                    }
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 250: {
                break;
            }
            case 251: {
                break;
            }
            case 252: {
                break;
            }
            case 253: {
                int adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                if (this.hasFlag(4)) {
                    int hi;
                    int lo_m = ram[adr] & 0xF;
                    int hi_m = ram[adr] >> 4 & 0xF;
                    int lo_a = this.registers[3] & 0xF;
                    int hi_a = this.registers[3] >> 4 & 0xF;
                    int lo = lo_a - lo_m - (this.hasFlag(0) ? 1 : 0);
                    if ((lo & 0x10) != 0) {
                        lo -= 6;
                    }
                    if (((hi = hi_a - hi_m - ((lo & 0x10) != 0 ? 1 : 0)) & 0x10) != 0) {
                        hi -= 6;
                    }
                    int result = lo & 0xF | hi << 4;
                    this.registers[3] = result &= 0xFF;
                    this.setFlag(0, hi < 15);
                } else {
                    this.registers[3] = this.registers[3] - ram[adr];
                    if (this.hasFlag(0)) {
                        this.registers[3] = this.registers[3] + 1;
                    }
                }
                this.setZeroFlag(this.registers[3]);
                this.setNegativeFlag(this.registers[3]);
                this.setCarryFlag(this.registers[3]);
                this.setOverflowFlag(this.registers[3]);
                this.registers[3] = this.registers[3] & 0xFF;
                pc += 3;
                break;
            }
            case 254: {
                int adr;
                int n = adr = this.getAddress(pc + 1, ram, rom, (byte)this.registers[4]);
                ram[n] = ram[n] + 1;
                this.setNegativeFlag(ram[adr]);
                this.setZeroFlag(ram[adr]);
                int n17 = adr;
                ram[n17] = ram[n17] & 0xFF;
                pc += 3;
                break;
            }
        }
        return pc;
    }

    private int getAddress(int pc, int[] ram, int[] rom, int offset) {
        int l = ram[pc] & 0xFF;
        int h = ram[pc + 1] & 0xFF;
        return (h << 8) + l + offset & 0xFFFF;
    }

    private int getValue(int pc, int[] ram, int[] rom) {
        return ram[pc] & 0xFF;
    }

    private void setZeroFlag(int value) {
        this.setFlag(1, (value & 0xFF) == 0);
    }

    private void setNegativeFlag(int value) {
        this.setFlag(64, (value & 0x80) == 128);
    }

    private void setCarryFlag(int value) {
        this.setFlag(0, (value & 0x100) == 256);
    }

    private void setOverflowFlag(int value) {
        this.setFlag(32, (value & 0x100) == 256);
    }

    private void setCompareStatus(int value) {
        if (value > 0) {
            this.setFlag(0, true);
        } else if (value < 0) {
            this.setFlag(64, true);
        } else {
            this.setFlag(0, true);
            this.setFlag(1, true);
        }
    }
}

