/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu.emulate;

import de.drazil.nerdsuite.cpu.emulate.ExecutionState;
import de.drazil.nerdsuite.cpu.emulate.ICPU;
import de.drazil.nerdsuite.cpu.emulate.IPlatform;

public abstract class AbstractPlatform
implements IPlatform {
    private int pc = 0;
    private int[] ram = new int[this.getMemorySize()];
    private int[] rom = new int[this.getMemorySize()];
    protected ICPU cpu;
    private Thread lifeCycleThread = null;

    @Override
    public abstract int getMemorySize();

    @Override
    public int[] getRAM() {
        return this.ram;
    }

    @Override
    public int[] getROM() {
        return this.rom;
    }

    protected void powerOn() {
        this.lifeCycleThread = new Thread(this);
        this.lifeCycleThread.start();
    }

    @Override
    public void resetCold() {
    }

    @Override
    public void resetWarm() {
    }

    @Override
    public void load() {
    }

    @Override
    public void run() {
        while (this.cpu.getExecutionState() != ExecutionState.TERMINATE) {
            if (this.cpu.getExecutionState() != ExecutionState.RUN) continue;
            this.pc = this.cpu.execute(this.pc, false);
        }
    }
}

