/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu.emulate;

import de.drazil.nerdsuite.cpu.emulate.AbstractPlatform;
import de.drazil.nerdsuite.cpu.emulate.Breakpoint;
import de.drazil.nerdsuite.cpu.emulate.ExecutionState;
import de.drazil.nerdsuite.cpu.emulate.IBreakpointListener;
import de.drazil.nerdsuite.cpu.emulate.ICPU;
import de.drazil.nerdsuite.cpu.emulate.IPlatform;
import de.drazil.nerdsuite.cpu.emulate.Watchpoint;
import de.drazil.nerdsuite.enums.ValueType;
import de.drazil.nerdsuite.util.NumericConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public abstract class AbstractCPU
implements ICPU {
    protected int pc = 0;
    protected int[] registers = new int[16];
    private Map<String, Breakpoint> breakpoints;
    private Map<String, Watchpoint> watchpoints;
    private Map<String, Integer> labels;
    private List<IBreakpointListener> breakpointListenerList;
    private IPlatform platform;
    private boolean debug = false;
    private boolean terminate = false;
    protected Stack<Integer> stack;
    private ExecutionState executionState = ExecutionState.RUN;

    protected AbstractCPU(IPlatform platform) {
        this.platform = platform;
        ((AbstractPlatform)this.platform).cpu = this;
        this.stack = new Stack();
        this.breakpoints = new HashMap<String, Breakpoint>();
        this.breakpointListenerList = new ArrayList<IBreakpointListener>();
        this.watchpoints = new HashMap<String, Watchpoint>();
        this.labels = new HashMap<String, Integer>();
    }

    public IPlatform getPlatform() {
        return this.platform;
    }

    @Override
    public void setExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
    }

    @Override
    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    @Override
    public long getProgramCounter() {
        return this.pc;
    }

    @Override
    public long getStatus() {
        return this.registers[0];
    }

    @Override
    public void setFlag(int flag, boolean set) {
        this.registers[0] = set ? this.registers[0] | flag : this.registers[0] & ~flag;
    }

    @Override
    public boolean hasFlag(int flag) {
        return (this.registers[0] & flag) == flag;
    }

    @Override
    public Breakpoint getBreakpoint(int pc) {
        return this.breakpoints.get(NumericConverter.toHexString(pc, 8));
    }

    @Override
    public void addBreakpoint(int address) {
        this.addBreakpoint(address, true);
    }

    @Override
    public void addBreakpoint(int address, boolean enabled) {
        this.addBreakpoint(address, enabled, 0);
    }

    @Override
    public void addBreakpoint(int address, boolean enabled, int cycleCount) {
        String _address = NumericConverter.toHexString(address, 8);
        Breakpoint bp = new Breakpoint(this.pc, enabled, cycleCount);
        this.breakpoints.put(_address, bp);
        this.fireBreakpointAdded(bp);
    }

    @Override
    public Collection<Breakpoint> getBreakpoints() {
        return this.breakpoints.values();
    }

    @Override
    public void removeBreakpoint(int address) {
        String _address = NumericConverter.toHexString(address, 8);
        Breakpoint bp = this.breakpoints.get(_address);
        if (bp != null) {
            this.breakpoints.remove(_address);
            this.fireBreakpointRemoved(bp);
        }
    }

    @Override
    public void setBreakpointEnabled(int address, boolean enabled) {
        String _address = NumericConverter.toHexString(address, 8);
        Breakpoint bp = this.breakpoints.get(_address);
        if (bp != null) {
            bp.setEnabled(enabled);
            this.fireBreakpointToggled(bp);
        }
    }

    @Override
    public void toggleBreakpoint(int address) {
        String _address = NumericConverter.toHexString(address, 8);
        Breakpoint bp = this.breakpoints.get(_address);
        if (bp != null) {
            bp.setEnabled(!bp.isEnabled());
            this.fireBreakpointToggled(bp);
        }
    }

    @Override
    public void disableAllBreakpoints() {
        this.breakpoints.values().stream().forEach(e -> e.setEnabled(false));
        this.fireBreakpointDisableAll();
    }

    @Override
    public void enableAllBreakpoints() {
        this.breakpoints.values().stream().forEach(e -> e.setEnabled(true));
        this.fireBreakpointEnableAll();
    }

    @Override
    public void addBreakpointListener(IBreakpointListener listener) {
        this.breakpointListenerList.add(listener);
    }

    @Override
    public void removeBreakpointListener(IBreakpointListener listener) {
        this.breakpointListenerList.remove(listener);
    }

    @Override
    public void addLabel(String label, int address) {
        this.labels.put(label, address);
    }

    @Override
    public void removeLabel(String label) {
        this.labels.remove(label);
    }

    @Override
    public void addWatchpoint(int address) {
        String _address = NumericConverter.toHexString(address, 2);
        this.watchpoints.put(_address, new Watchpoint(address, ValueType.BYTE));
    }

    @Override
    public void addWatchpoint(int address, ValueType valueType) {
        String _address = NumericConverter.toHexString(address, valueType.getSize() * 2);
        this.watchpoints.put(_address, new Watchpoint(address, valueType));
    }

    @Override
    public void addWatchpoint(String label, ValueType valueType) {
        int address = this.labels.get(label);
        this.watchpoints.put(label, new Watchpoint(address, valueType));
    }

    @Override
    public void removeWatchpoint(int address) {
    }

    @Override
    public void removeWatchpoint(String label) {
    }

    private void fireBreakpointToggled(Breakpoint breakpoint) {
        this.breakpointListenerList.stream().forEach(e -> e.breakpointToggled(breakpoint));
    }

    private void fireBreakpointDisableAll() {
        this.breakpointListenerList.stream().forEach(e -> e.breakpointDisableAll());
    }

    private void fireBreakpointEnableAll() {
        this.breakpointListenerList.stream().forEach(e -> e.breakpointEnableAll());
    }

    private void fireBreakpointAdded(Breakpoint breakpoint) {
        this.breakpointListenerList.stream().forEach(e -> e.breakpointAdded(breakpoint));
    }

    private void fireBreakpointRemoved(Breakpoint breakpoint) {
        this.breakpointListenerList.stream().forEach(e -> e.breakpointRemoved(breakpoint));
    }
}

