/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu.decode;

import de.drazil.nerdsuite.model.InstructionType;
import de.drazil.nerdsuite.model.Range;
import de.drazil.nerdsuite.model.ReferenceType;
import de.drazil.nerdsuite.model.Value;
import java.util.ArrayList;
import java.util.List;

public class InstructionLine {
    private String name;
    private Value programCounter;
    private Range range;
    private Value referenceValue;
    private InstructionType instructionType;
    private ReferenceType referenceType;
    private boolean isPassed;
    private boolean endOfCode;
    private Object userObject;
    private boolean isRenderable;
    private String labelName = "";
    private List<Value> callerList = null;

    public InstructionLine() {
    }

    public InstructionLine(Value programCounter, Range range) {
        this(programCounter, range, InstructionType.Asm, ReferenceType.NoReference);
    }

    public InstructionLine(Value programCounter, Range range, InstructionType instructionType, ReferenceType referenceType) {
        this.callerList = new ArrayList<Value>();
        this.programCounter = programCounter;
        this.range = range;
        this.instructionType = instructionType;
        this.referenceType = referenceType;
        this.isPassed = false;
        this.endOfCode = false;
        this.isRenderable = false;
    }

    public void addCaller(Value caller) {
        this.callerList.add(caller);
    }

    public boolean hasReferenceValue() {
        return this.referenceValue != null;
    }

    public String toString() {
        return (Object)((Object)this.instructionType) + "| pc:" + this.getProgramCounter() + ", " + this.range + "  refValue:" + this.getReferenceValue() + "    " + (Object)((Object)this.getReferenceType());
    }

    public String getName() {
        return this.name;
    }

    public Value getProgramCounter() {
        return this.programCounter;
    }

    public Range getRange() {
        return this.range;
    }

    public Value getReferenceValue() {
        return this.referenceValue;
    }

    public InstructionType getInstructionType() {
        return this.instructionType;
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public boolean isPassed() {
        return this.isPassed;
    }

    public boolean isEndOfCode() {
        return this.endOfCode;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public boolean isRenderable() {
        return this.isRenderable;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public List<Value> getCallerList() {
        return this.callerList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProgramCounter(Value programCounter) {
        this.programCounter = programCounter;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public void setReferenceValue(Value referenceValue) {
        this.referenceValue = referenceValue;
    }

    public void setInstructionType(InstructionType instructionType) {
        this.instructionType = instructionType;
    }

    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public void setPassed(boolean isPassed) {
        this.isPassed = isPassed;
    }

    public void setEndOfCode(boolean endOfCode) {
        this.endOfCode = endOfCode;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void setRenderable(boolean isRenderable) {
        this.isRenderable = isRenderable;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public void setCallerList(List<Value> callerList) {
        this.callerList = callerList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstructionLine)) {
            return false;
        }
        InstructionLine other = (InstructionLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPassed() != other.isPassed()) {
            return false;
        }
        if (this.isEndOfCode() != other.isEndOfCode()) {
            return false;
        }
        if (this.isRenderable() != other.isRenderable()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Value this$programCounter = this.getProgramCounter();
        Value other$programCounter = other.getProgramCounter();
        if (this$programCounter == null ? other$programCounter != null : !this$programCounter.equals(other$programCounter)) {
            return false;
        }
        Range this$range = this.getRange();
        Range other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        Value this$referenceValue = this.getReferenceValue();
        Value other$referenceValue = other.getReferenceValue();
        if (this$referenceValue == null ? other$referenceValue != null : !this$referenceValue.equals(other$referenceValue)) {
            return false;
        }
        InstructionType this$instructionType = this.getInstructionType();
        InstructionType other$instructionType = other.getInstructionType();
        if (this$instructionType == null ? other$instructionType != null : !((Object)((Object)this$instructionType)).equals((Object)other$instructionType)) {
            return false;
        }
        ReferenceType this$referenceType = this.getReferenceType();
        ReferenceType other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !((Object)((Object)this$referenceType)).equals((Object)other$referenceType)) {
            return false;
        }
        Object this$userObject = this.getUserObject();
        Object other$userObject = other.getUserObject();
        if (this$userObject == null ? other$userObject != null : !this$userObject.equals(other$userObject)) {
            return false;
        }
        String this$labelName = this.getLabelName();
        String other$labelName = other.getLabelName();
        if (this$labelName == null ? other$labelName != null : !this$labelName.equals(other$labelName)) {
            return false;
        }
        List<Value> this$callerList = this.getCallerList();
        List<Value> other$callerList = other.getCallerList();
        return !(this$callerList == null ? other$callerList != null : !((Object)this$callerList).equals(other$callerList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstructionLine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPassed() ? 79 : 97);
        result = result * 59 + (this.isEndOfCode() ? 79 : 97);
        result = result * 59 + (this.isRenderable() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Value $programCounter = this.getProgramCounter();
        result = result * 59 + ($programCounter == null ? 43 : $programCounter.hashCode());
        Range $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        Value $referenceValue = this.getReferenceValue();
        result = result * 59 + ($referenceValue == null ? 43 : $referenceValue.hashCode());
        InstructionType $instructionType = this.getInstructionType();
        result = result * 59 + ($instructionType == null ? 43 : ((Object)((Object)$instructionType)).hashCode());
        ReferenceType $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : ((Object)((Object)$referenceType)).hashCode());
        Object $userObject = this.getUserObject();
        result = result * 59 + ($userObject == null ? 43 : $userObject.hashCode());
        String $labelName = this.getLabelName();
        result = result * 59 + ($labelName == null ? 43 : $labelName.hashCode());
        List<Value> $callerList = this.getCallerList();
        result = result * 59 + ($callerList == null ? 43 : ((Object)$callerList).hashCode());
        return result;
    }
}

