/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu.decode;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;

public class HexViewContent
implements StyledTextContent {
    private List<TextChangeListener> listenerList = new ArrayList<TextChangeListener>();
    private StringBuilder content = new StringBuilder();
    private int lineWidth;

    public HexViewContent(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void addTextChangeListener(TextChangeListener listener) {
        this.listenerList.add(listener);
    }

    public int getCharCount() {
        return this.content.length();
    }

    public String getLine(int lineIndex) {
        if (this.content.length() == 0) {
            return "";
        }
        int start = this.getOffsetAtLine(lineIndex);
        int x = this.content.length() - start;
        String s = this.getTextRange(start, x < this.lineWidth ? x : this.lineWidth);
        return s;
    }

    public int getLineAtOffset(int offset) {
        int result = offset / this.lineWidth;
        if (result > this.getLineCount()) {
            return this.getLineCount() - 1;
        }
        return result;
    }

    public int getLineCount() {
        return this.content.length() / this.lineWidth + 1;
    }

    public String getLineDelimiter() {
        return "";
    }

    public int getOffsetAtLine(int lineIndex) {
        return lineIndex * this.lineWidth;
    }

    public String getTextRange(int start, int length) {
        return this.content.substring(start, start + length);
    }

    public void removeTextChangeListener(TextChangeListener listener) {
        this.listenerList.remove(listener);
    }

    public void setText(String text) {
        this.content.setLength(0);
        this.content.append(text);
        this.fireSetText();
    }

    private void fireSetText() {
        TextChangedEvent changedEvent = new TextChangedEvent((StyledTextContent)this);
        for (TextChangeListener listener : this.listenerList) {
            listener.textSet(changedEvent);
        }
    }

    public void replaceTextRange(int start, int replaceLength, String text) {
    }
}

