/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu.decode;

import de.drazil.nerdsuite.cpu.decode.dialect.KickAssemblerDialect;
import de.drazil.nerdsuite.cpu.platform.C64Platform;
import de.drazil.nerdsuite.widget.HexViewWidget;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.swt.widgets.Composite;

public class DisassemblerView {
    private HexViewWidget hvw;

    @PostConstruct
    public void postConstruct(Composite parent, EMenuService menuService) {
        C64Platform platform = new C64Platform(new KickAssemblerDialect(), false);
        this.hvw = new HexViewWidget(parent, 512, platform);
        menuService.registerContextMenu((Object)this.hvw.getDisassemblyView(), "de.drazil.nerdsuite.popupmenu.disassemblyView");
        menuService.registerContextMenu((Object)this.hvw.getBinaryView(), "de.drazil.nerdsuite.popupmenu.binaryView");
    }

    @Inject
    @Optional
    public void jumpToAddress(@UIEventTopic(value="JumpToAddress") Object o) {
        this.hvw.jumpToAddress();
    }

    @Inject
    @Optional
    public void returnToCaller(@UIEventTopic(value="ReturnToOrigin") Object o) {
        this.hvw.returnToOrigin();
    }

    @Inject
    @Optional
    public void setLabel(@UIEventTopic(value="SetLabel") String name) {
        this.hvw.setLabel(name);
    }

    @PreDestroy
    public void preDestroy() {
    }

    @Focus
    public void onFocus() {
    }

    @Persist
    public void save() {
    }
}

