/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu.decode;

import de.drazil.nerdsuite.util.BinaryFileHandler;
import de.drazil.nerdsuite.util.NumericConverter;
import java.io.File;

public class Binary2SourceConverter {
    public static final int CHARSET = 1;
    public static final int CHARSET_DOUBLE_X = 2;
    public static final int CHARSET_DOUBLE_Y = 4;
    public static final int SPRITE = 8;
    public static final int MULTICOLOR = 16;
    public static final int AS_BINARY_VALUE = 10;
    public static final int AS_HEX_VALUE = 20;
    public static final int AS_DECIMAL_VALUE = 30;
    public static final char COLOR0 = '.';
    public static final char COLOR1 = 'o';
    public static final char COLOR2 = 'O';
    public static final char COLOR3 = 'A';

    public static StringBuilder convertBinaryToText(File file, int sourceFormat, int valueOutputFormat, boolean skipLocation, boolean writeComment) {
        Binary2SourceConverter.checkFormatSettings(sourceFormat);
        StringBuilder sb = new StringBuilder();
        byte[] binaryData = null;
        try {
            binaryData = BinaryFileHandler.readFile(file, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int index = 0;
        int width = 1;
        int height = 8;
        int step = 1;
        if ((sourceFormat & 7) != 7 && (sourceFormat & 5) != 5) {
            if ((sourceFormat & 3) == 3) {
                step = 8;
            } else if ((sourceFormat & 1) != 1 && (sourceFormat & 8) == 8) {
                width = 3;
                height = 21;
            }
        }
        int rows = 0;
        while (index < binaryData.length) {
            byte b = binaryData[index];
            if (index == 0 && !skipLocation) {
                sb.append(".pc $");
                NumericConverter.toHexString(binaryData[1], sb);
                NumericConverter.toHexString(binaryData[0], sb);
                sb.append(" \"" + file.getName() + "\"\n");
                index = 2;
            }
            if (index <= 1) continue;
            sb.append(".byte ");
            if (valueOutputFormat == 20) {
                NumericConverter.toHexString(binaryData, index, width, step, sb);
            } else if (valueOutputFormat == 10) {
                NumericConverter.toBinaryString(binaryData, index, width, step, sb);
            } else if (valueOutputFormat == 30) {
                NumericConverter.toDecimalString(binaryData, index, width, step, sb);
            }
            if (writeComment) {
                sb.append(" //");
                Binary2SourceConverter.toCommentString(binaryData, index, width, step, sourceFormat, sb);
            }
            sb.append('\n');
            index += width;
            if (++rows < height) continue;
            ++index;
            rows = 0;
            sb.append("//----------------------------------------------------------\n");
        }
        return sb;
    }

    private static void checkFormatSettings(int format) {
        int source = 9;
        if ((format & source) == source) {
            throw new RuntimeException("please CHARSET OR SPRITE format only");
        }
    }

    private static void toCommentString(byte b, int format, StringBuilder sb) {
        Binary2SourceConverter.toCommentString(new byte[]{b}, 0, 1, 1, format, sb);
    }

    private static void toCommentString(byte[] byteArray, int offset, int len, int step, int format, StringBuilder sb) {
        int i = offset;
        while (i < offset + len) {
            int cb = 1;
            char[] c = new char[]{'.', '.', '.', '.', '.', '.', '.', '.'};
            if ((format & 0x10) == 16) {
                byte mcByte = byteArray[i];
                int j = 8;
                while (j > 0) {
                    byte x = (byte)(mcByte & 3);
                    int colorSymbol = 46;
                    if (x == 1) {
                        colorSymbol = 111;
                    } else if (x == 2) {
                        colorSymbol = 79;
                    } else if (x == 3) {
                        colorSymbol = 65;
                    }
                    c[j - 1] = colorSymbol;
                    c[j - 2] = colorSymbol;
                    mcByte = (byte)(mcByte >> 2);
                    j -= 2;
                }
            } else {
                int j = 1;
                while (j <= 8) {
                    if ((byteArray[i] & cb) == cb) {
                        c[8 - j] = 79;
                    }
                    cb = (byte)(cb << 1);
                    ++j;
                }
            }
            sb.append(String.valueOf(c));
            ++i;
        }
    }

    public static void main(String[] args) {
        StringBuilder sb = Binary2SourceConverter.convertBinaryToText(new File("/Users/drazil/Downloads/gi-joe_major_bludd.spr"), 24, 20, false, true);
        System.out.println(sb);
    }
}

