/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu;

import de.drazil.nerdsuite.cpu.IDecoder;
import de.drazil.nerdsuite.cpu.decode.InstructionLine;
import de.drazil.nerdsuite.model.Opcode;
import de.drazil.nerdsuite.model.Range;
import de.drazil.nerdsuite.model.RangeType;
import de.drazil.nerdsuite.model.ReferenceType;
import de.drazil.nerdsuite.model.Value;
import java.util.List;

public interface ICPU
extends IDecoder {
    public static final int JUMP_MODE = 1;
    public static final int BRANCH_MODE = 2;
    public static final int SUBROUTINE_MODE = 4;

    public int getWord(byte[] var1, int var2);

    public int getByte(byte[] var1, int var2);

    public Opcode getOpcodeByIndex(String var1, String var2, byte[] var3, int var4);

    public Opcode getOpcodeById(String var1, String var2, int var3);

    public void clear();

    public void resetLine();

    public int getLine();

    public int getIndexOf(InstructionLine var1);

    public void addInstructionLine(InstructionLine var1);

    public InstructionLine splitInstructionLine(InstructionLine var1, Value var2, Value var3);

    public InstructionLine splitInstructionLine(InstructionLine var1, Value var2, Value var3, RangeType var4, ReferenceType var5);

    public InstructionLine findInstructionLineByProgrammCounter(Value var1);

    public InstructionLine findInstructionLineByOffset(Value var1);

    public InstructionLine findInstructionLineByPC(Value var1);

    public InstructionLine findInstructionLineByRef(Value var1);

    public InstructionLine findInstructionLineByPC(int var1);

    public InstructionLine findInstructionLineByRef(int var1);

    public List<InstructionLine> getInstructionLineList();

    public InstructionLine getLastInstructionLine();

    public Value getInstructionValue(byte[] var1, Range var2);

    public void compressRanges();

    public void packInstructionLines(InstructionLine var1, int var2);
}

