/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu;

import de.drazil.nerdsuite.cpu.AbstractCPU;
import de.drazil.nerdsuite.cpu.Endianness;
import de.drazil.nerdsuite.cpu.decode.InstructionLine;
import de.drazil.nerdsuite.enums.ValueType;
import de.drazil.nerdsuite.model.Address;
import de.drazil.nerdsuite.model.DisassemblingRange;
import de.drazil.nerdsuite.model.InstructionType;
import de.drazil.nerdsuite.model.Opcode;
import de.drazil.nerdsuite.model.PlatformData;
import de.drazil.nerdsuite.model.Range;
import de.drazil.nerdsuite.model.ReferenceType;
import de.drazil.nerdsuite.model.Value;
import de.drazil.nerdsuite.util.NumericConverter;
import de.drazil.nerdsuite.widget.IContentProvider;

public class CPU_Z80
extends AbstractCPU {
    @Override
    public int getWord(byte[] byteArray, int offset) {
        return NumericConverter.getWordAsInt(byteArray, offset, Endianness.LittleEndian);
    }

    @Override
    public void decode(IContentProvider contentProvider, Value pc, PlatformData platformData, DisassemblingRange discoverableRange, int stage) {
        InstructionLine currentLine = null;
        InstructionLine newLine = null;
        Value value = null;
        Opcode opcode = null;
        this.line = 1;
        while (currentLine != null) {
            if (!currentLine.isPassed()) {
                Range range = currentLine.getRange();
                int offset = range.getOffset();
                String so = String.format("%04X", offset);
                String prefix1 = String.format("%02X", NumericConverter.toInt(contentProvider.getContentAtOffset(offset)));
                String prefix2 = String.format("%02X", NumericConverter.toInt(contentProvider.getContentAtOffset(offset + 1)));
                String prefix = String.valueOf(prefix1) + prefix2;
                int addLen = 0;
                if (prefix.equals("DDCB") || prefix.equals("DCCB")) {
                    addLen = 2;
                    opcode = this.getOpcodeByIndex(platformData.getPlatformId(), prefix, contentProvider.getContentArray(), offset + 2);
                } else if (prefix1.equals("CB") || prefix1.equals("ED") || prefix1.equals("DD") || prefix1.equals("FD")) {
                    addLen = 1;
                    opcode = this.getOpcodeByIndex(platformData.getPlatformId(), prefix1, contentProvider.getContentArray(), offset + 1);
                } else {
                    opcode = this.getOpcodeByIndex(platformData.getPlatformId(), "", contentProvider.getContentArray(), offset);
                }
                String addressingMode = opcode.getAddressingMode().getId();
                String addressingModeTemplate = opcode.getAddressingMode().getArgumentTemplate();
                String instructionType = opcode.getType();
                int len = opcode.getAddressingMode().getLen() + addLen;
                boolean isAdress = false;
                String addressingModeString = addressingModeTemplate;
                if (addressingModeTemplate.contains("{WORD}")) {
                    isAdress = true;
                    value = new Value(this.getWord(contentProvider.getContentArray(), offset + opcode.getValueStartPos()));
                    addressingModeString = addressingModeTemplate.replace("{WORD}", String.format("%04X", value.getValue()));
                } else if (addressingModeTemplate.contains("{BYTE}")) {
                    value = new Value(this.getByte(contentProvider.getContentArray(), offset + opcode.getValueStartPos()), ValueType.BYTE);
                    if ("BRANCH_REL".equals(instructionType)) {
                        isAdress = true;
                        value = currentLine.getProgramCounter().add((value.getValue() & 0x80) == 128 ? -(((value.getValue() ^ 0xFF) & 0xFF) - 1) : value.add(2).getValue());
                        addressingModeString = addressingModeTemplate.replace("{BYTE}", String.format("%04X", value.getValue()));
                    } else {
                        addressingModeString = addressingModeTemplate.replace("{BYTE}", String.format("%02X", value.getValue()));
                    }
                }
                String byteString = "";
                int i = 0;
                while (i < 4) {
                    byteString = i < opcode.getAddressingMode().getLen() + addLen ? String.valueOf(byteString) + String.format("%02X ", contentProvider.getContentAtOffset(offset + i)) : String.valueOf(byteString) + "   ";
                    ++i;
                }
                String instruction = String.format("%s: %s %s %s\n", so, byteString, opcode.getMnemonic(), addressingModeString);
                System.out.printf(instruction, new Object[0]);
                if (offset + len > discoverableRange.getOffset() + discoverableRange.getLen()) break;
                currentLine.setInstructionType(InstructionType.Asm);
                Address refAddress = null;
                if (isAdress) {
                    int v = value.getValue();
                    refAddress = platformData.getPlatformAddressList().stream().filter(p -> p.getAddressValue() == v).findFirst().orElse(null);
                }
                int label = currentLine.getProgramCounter().getValue();
                Address pcAddress = platformData.getPlatformAddressList().stream().filter(p -> p.getAddressValue() == label).findFirst().orElse(null);
                currentLine.setUserObject(new Object[]{so, pcAddress == null ? "" : pcAddress.getConstName(), byteString, opcode.getMnemonic(), addressingModeString, refAddress != null && "MOD".equals(instructionType) ? refAddress.getConstName() : ""});
                newLine = this.split(currentLine, pc, new Value(offset + len));
                if (newLine == null) break;
                if (newLine.getRange().getLength() < 0 || newLine.getRange().getLength() == 0) {
                    System.out.println(newLine.getProgramCounter() + ": negative length or zero ..");
                }
                ++this.line;
            }
            currentLine.setReferenceValue(value);
            currentLine.setPassed(true);
            currentLine = newLine;
            if (currentLine.getInstructionType() == InstructionType.Asm) continue;
            currentLine = this.getNextUnspecifiedLine(currentLine);
        }
    }

    private InstructionLine markEmptyBlockAsData(byte[] byteArray, Value pc, InstructionLine currentLine) {
        int rowIndex = 0;
        InstructionLine newLine = null;
        InstructionLine specifiedLine = null;
        int brkCount = 0;
        int i = 0;
        while (i < 2) {
            if (byteArray[currentLine.getRange().getOffset() + i] == 0) {
                ++brkCount;
            }
            ++i;
        }
        boolean foundLine = false;
        newLine = currentLine;
        if (brkCount == 2) {
            rowIndex = this.getInstructionLineList().indexOf(currentLine);
            while (!foundLine) {
                specifiedLine = this.getInstructionLineList().get(rowIndex++);
                if (specifiedLine.getInstructionType() == InstructionType.Data) continue;
                foundLine = true;
                break;
            }
            newLine = this.split(currentLine, pc, new Value(specifiedLine.getRange().getOffset()));
            currentLine.setInstructionType(InstructionType.Data);
        }
        return newLine;
    }

    private InstructionLine getNextUnspecifiedLine(InstructionLine currentLine) {
        InstructionLine nextLine = currentLine;
        if (currentLine != null && currentLine.getInstructionType() != InstructionType.Data) {
            int nextIndex = this.getInstructionLineList().indexOf(currentLine) + 1;
            nextLine = nextIndex < this.getInstructionLineList().size() ? this.getNextUnspecifiedLine(this.getInstructionLineList().get(nextIndex)) : null;
        }
        return nextLine;
    }

    private InstructionLine split(InstructionLine instructionLine, Value pc, Value offset) {
        int index;
        InstructionLine newLine = this.splitInstructionLine(instructionLine, pc, offset);
        if (newLine == null && (index = this.getInstructionLineList().indexOf(instructionLine) + 1) < this.getInstructionLineList().size()) {
            newLine = this.getInstructionLineList().get(index);
        }
        return newLine;
    }

    @Override
    public void compressRanges() {
        int index = 0;
        InstructionLine currentLine = null;
        while (index < this.getInstructionLineList().size() - 1) {
            currentLine = this.getInstructionLineList().get(index);
            if (currentLine.getReferenceType() == ReferenceType.DataReference) {
                InstructionLine nextLine;
                int nextIndex = index + 1;
                while (nextIndex <= this.getInstructionLineList().size() - 1 && (nextLine = this.getInstructionLineList().get(nextIndex)).getReferenceType() != ReferenceType.DataReference && nextLine.getInstructionType() != InstructionType.Asm) {
                    Range range = currentLine.getRange();
                    range.setLength(range.getLength() + nextLine.getRange().getLength());
                    this.getInstructionLineList().remove(nextLine);
                }
            }
            ++index;
        }
    }
}

