/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu;

import de.drazil.nerdsuite.cpu.AbstractCPU;
import de.drazil.nerdsuite.cpu.Endianness;
import de.drazil.nerdsuite.cpu.decode.InstructionLine;
import de.drazil.nerdsuite.enums.ValueType;
import de.drazil.nerdsuite.model.Address;
import de.drazil.nerdsuite.model.AddressingMode;
import de.drazil.nerdsuite.model.DisassemblingRange;
import de.drazil.nerdsuite.model.InstructionType;
import de.drazil.nerdsuite.model.Opcode;
import de.drazil.nerdsuite.model.PlatformData;
import de.drazil.nerdsuite.model.Pointer;
import de.drazil.nerdsuite.model.Range;
import de.drazil.nerdsuite.model.RangeType;
import de.drazil.nerdsuite.model.ReferenceType;
import de.drazil.nerdsuite.model.Value;
import de.drazil.nerdsuite.util.NumericConverter;
import de.drazil.nerdsuite.widget.IContentProvider;
import java.util.HashMap;
import java.util.Map;

public class CPU_6510
extends AbstractCPU {
    private Map<String, Boolean> pointerTableRemindMap = new HashMap<String, Boolean>();
    private Map<String, Value> jumpMap = new HashMap<String, Value>();

    @Override
    public int getWord(byte[] byteArray, int offset) {
        return NumericConverter.getWordAsInt(byteArray, offset, Endianness.LittleEndian);
    }

    private void printDisassembly(InstructionLine instructionLine, Opcode opcode, Value value, Address address) {
        if (instructionLine.getInstructionType() == InstructionType.Asm) {
            int len = opcode.getAddressingMode().getLen();
            String sv = "";
            if (len - 1 > 0) {
                sv = NumericConverter.toHexString(value.getValue(), (len - 1) * 2);
            }
            String pan = String.format("< %s >", address != null ? address.getDescription() : "");
            instructionLine.setUserObject(new Object[]{instructionLine.getProgramCounter(), opcode.getMnemonic(), opcode.getAddressingMode().getArgumentTemplate().replace("{value}", sv), address != null ? pan : ""});
        }
    }

    @Override
    public void decode(IContentProvider contentProvider, Value pc, PlatformData platformData, DisassemblingRange decodableRange, int stage) {
        if (decodableRange.getRangeType() == RangeType.Code) {
            InstructionLine currentLine = this.findInstructionLineByOffset(new Value(decodableRange.getOffset()));
            currentLine = this.split(currentLine, pc, new Value(decodableRange.getOffset()));
            InstructionLine newLine = null;
            Value value = null;
            while (currentLine != null) {
                if (!currentLine.isPassed()) {
                    Range range = currentLine.getRange();
                    int offset = range.getOffset();
                    String so = String.format("%04X", currentLine.getProgramCounter().getValue());
                    int index = contentProvider.getContentAtOffset(offset) & 0xFF;
                    Opcode opcode = this.getOpcodeById(platformData.getPlatformId(), "", index);
                    String addressingMode = opcode.getAddressingMode().getId();
                    String instructionType = opcode.getType();
                    int len = opcode.getAddressingMode().getLen();
                    if (offset + len > decodableRange.getOffset() + decodableRange.getLen()) break;
                    value = this.getInstructionValue(contentProvider.getContentArray(), new Range(contentProvider.getContentOffset() + offset, len));
                    currentLine.setInstructionType(InstructionType.Asm);
                    if ("branch".equals(instructionType)) {
                        boolean doSplitLine = true;
                        if ("rel".equals(addressingMode)) {
                            value = currentLine.getProgramCounter().add((value.getValue() & 0x80) == 128 ? -(((value.getValue() ^ 0xFF) & 0xFF) - 1) : value.add(2).getValue());
                        } else {
                            "ind".equals(addressingMode);
                        }
                        currentLine.setReferenceValue(value);
                    } else if (!"abs".equals(addressingMode) && !"absx".equals(addressingMode)) {
                        "absy".equals(addressingMode);
                    }
                    String byteString = "";
                    int i = 0;
                    while (i < 4) {
                        byteString = i < opcode.getAddressingMode().getLen() ? String.valueOf(byteString) + String.format("%02X ", contentProvider.getContentAtOffset(offset + i)) : String.valueOf(byteString) + "   ";
                        ++i;
                    }
                    Address address = null;
                    if ("mod".equals(instructionType) || "branch".equals(instructionType)) {
                        int v = value.getValue();
                        address = platformData.getPlatformAddressList().stream().filter(p -> p.getAddressValue() == v).findFirst().orElse(null);
                    }
                    String sv = "";
                    if (len - 1 > 0) {
                        sv = NumericConverter.toHexString(value.getValue(), (len - 1) * 2);
                    }
                    String addressingModeString = opcode.getAddressingMode().getArgumentTemplate().replace("{value}", sv);
                    currentLine.setUserObject(new Object[]{decodableRange.getRangeType().toString(), so, "", byteString, opcode.getMnemonic(), addressingModeString, address != null ? address.getConstName() : ""});
                    newLine = this.split(currentLine, pc, new Value(offset + len));
                    if (newLine == null) break;
                    if (newLine.getRange().getLength() < 0 || newLine.getRange().getLength() == 0) {
                        System.out.println(newLine.getProgramCounter() + ": negative length or zero ..");
                    }
                }
                currentLine.setReferenceValue(value);
                currentLine.setPassed(true);
                currentLine = newLine;
                if (currentLine.getInstructionType() == InstructionType.Asm) continue;
                currentLine = this.getNextUnspecifiedLine(currentLine);
            }
        } else if (decodableRange.getRangeType() == RangeType.Binary) {
            InstructionLine currentLine = this.findInstructionLineByOffset(new Value(decodableRange.getOffset()));
            int from = pc.getValue() + decodableRange.getOffset();
            int till = pc.getValue() + decodableRange.getOffset() + decodableRange.getLen() - 1;
            String soFrom = String.format("%04X", from);
            String soTill = String.format("%04X", till);
            currentLine.setUserObject(new Object[]{decodableRange.getRangeType().toString(), soFrom, "", "DATA BLOCK from :" + soFrom + " to " + soTill});
        }
    }

    private InstructionLine markEmptyBlockAsData(byte[] byteArray, Value pc, InstructionLine currentLine) {
        int rowIndex = 0;
        InstructionLine newLine = null;
        InstructionLine specifiedLine = null;
        int brkCount = 0;
        int i = 0;
        while (i < 2) {
            if (byteArray[currentLine.getRange().getOffset() + i] == 0) {
                ++brkCount;
            }
            ++i;
        }
        boolean foundLine = false;
        newLine = currentLine;
        if (brkCount == 2) {
            rowIndex = this.getInstructionLineList().indexOf(currentLine);
            while (!foundLine) {
                specifiedLine = this.getInstructionLineList().get(rowIndex++);
                if (specifiedLine.getInstructionType() == InstructionType.Data) continue;
                foundLine = true;
                break;
            }
            newLine = this.split(currentLine, pc, new Value(specifiedLine.getRange().getOffset()));
            currentLine.setInstructionType(InstructionType.Data);
        }
        return newLine;
    }

    private InstructionLine getNextUnspecifiedLine(InstructionLine currentLine) {
        InstructionLine nextLine = currentLine;
        if (currentLine != null && currentLine.getInstructionType() != InstructionType.Data) {
            int nextIndex = this.getInstructionLineList().indexOf(currentLine) + 1;
            nextLine = nextIndex < this.getInstructionLineList().size() ? this.getNextUnspecifiedLine(this.getInstructionLineList().get(nextIndex)) : null;
        }
        return nextLine;
    }

    private InstructionLine split(InstructionLine instructionLine, Value pc, Value offset) {
        int index;
        InstructionLine newLine = this.splitInstructionLine(instructionLine, pc, offset);
        if (newLine == null && (index = this.getInstructionLineList().indexOf(instructionLine) + 1) < this.getInstructionLineList().size()) {
            newLine = this.getInstructionLineList().get(index);
        }
        return newLine;
    }

    private void detectIndirectJumpTable(byte[] byteArray, Value pc, InstructionLine instructionLine, Opcode opcode, Value value, PlatformData platformData) {
        System.out.println("jumptable detection");
        InstructionLine lowByteLine = null;
        Value matchValue = new Value(0);
        int index = this.getInstructionLineList().indexOf(instructionLine) - 1;
        Opcode lookupOpcode = null;
        AddressingMode lookupAddressingMode = null;
        while (!matchValue.matches(value)) {
            lowByteLine = this.getInstructionLineList().get(index);
            lookupOpcode = this.getOpcodeByIndex("", "", byteArray, lowByteLine.getRange().getOffset());
            lookupAddressingMode = lookupOpcode.getAddressingMode();
            if (lookupAddressingMode.getId().startsWith("abs") || lookupAddressingMode.getId().startsWith("zp")) {
                matchValue = this.getInstructionValue(byteArray, new Range(lowByteLine.getRange().getOffset(), lowByteLine.getRange().getLength()));
            } else {
                matchValue.clear();
            }
            --index;
        }
        InstructionLine lowAddressLine = this.getInstructionLineList().get(index);
        InstructionLine highAddressLine = this.getInstructionLineList().get(index + 2);
        InstructionLine lowTableLine = this.findInstructionLineByPC(lowAddressLine.getReferenceValue());
        InstructionLine highTableLine = this.findInstructionLineByPC(highAddressLine.getReferenceValue());
        String jumpTableId = lowAddressLine.getReferenceValue() + "|" + highAddressLine.getReferenceValue();
        Boolean tableChecked = this.pointerTableRemindMap.get(jumpTableId);
        if (tableChecked == null) {
            this.pointerTableRemindMap.put(jumpTableId, true);
            int jumpTableSize = Math.abs(lowAddressLine.getReferenceValue().getValue() - highAddressLine.getReferenceValue().getValue());
            int i = 0;
            while (i < jumpTableSize) {
                int lowByte = this.getByte(byteArray, lowTableLine.getRange().getOffset() + i);
                int highByte = this.getByte(byteArray, highTableLine.getRange().getOffset() + i);
                int jumpMark = highByte << 8 | lowByte;
                InstructionLine jmpLine = this.findInstructionLineByPC(jumpMark);
                lowTableLine.setReferenceValue(new Value(jumpMark, ValueType.LOWBYTE));
                lowTableLine.setInstructionType(InstructionType.Data);
                lowTableLine.setReferenceType(ReferenceType.DataReference);
                highTableLine.setReferenceValue(new Value(jumpMark, ValueType.HIGHBYTE));
                highTableLine.setInstructionType(InstructionType.Data);
                highTableLine.setReferenceType(ReferenceType.DataReference);
                ++i;
            }
        }
        System.out.println("ready table detection");
    }

    private void detectPointers(byte[] byteArray, Value pc, InstructionLine instructionLine, PlatformData platformData) {
        InstructionLine checkLineB;
        Opcode opcodeB;
        int checkIndex = this.getInstructionLineList().indexOf(instructionLine);
        InstructionLine checkLineA = this.getInstructionLineList().get(checkIndex);
        Pointer resultPointer = null;
        Value valueA = new Value(0);
        Value valueB = new Value(0);
        Opcode opcodeA = this.getOpcodeByIndex("C64", "", byteArray, checkLineA.getRange().getOffset());
        valueA = this.getInstructionValue(byteArray, new Range(checkLineA.getRange().getOffset(), checkLineA.getRange().getLength()));
        if (opcodeA != null && this.isStoreInstruction(opcodeA.getMnemonic()) && !this.isDataAddress(valueA, platformData) && (opcodeB = this.getOpcodeByIndex("C64", "", byteArray, (checkLineB = this.getInstructionLineList().get(checkIndex - 2)).getRange().getOffset())) != null) {
            valueB = this.getInstructionValue(byteArray, new Range(checkLineB.getRange().getOffset(), checkLineB.getRange().getLength()));
            if (this.isStoreInstruction(opcodeB.getMnemonic()) && !this.isDataAddress(valueA, platformData) && Math.abs(valueB.getValue() - valueA.getValue()) == 1) {
                InstructionLine pointerA = this.getInstructionLineList().get(checkIndex - 1);
                Opcode pointerAopcode = this.getOpcodeByIndex("C64", "", byteArray, pointerA.getRange().getOffset());
                InstructionLine pointerB = this.getInstructionLineList().get(checkIndex - 3);
                Opcode pointerBopcode = this.getOpcodeByIndex("C64", "", byteArray, pointerB.getRange().getOffset());
                if (pointerAopcode.getAddressingMode().getId().equals("imm") && pointerBopcode.getAddressingMode().getId().equals("imm")) {
                    int lowByte = this.getByte(byteArray, pointerB.getRange().getOffset() + 1);
                    int highByte = this.getByte(byteArray, pointerA.getRange().getOffset() + 1);
                    Value reference = new Value(highByte << 8 | lowByte);
                    Boolean checked = this.pointerTableRemindMap.get(String.valueOf(reference));
                    if (checked != null) {
                        this.pointerTableRemindMap.put(String.valueOf(reference), Boolean.TRUE);
                        InstructionLine pointerLine = this.findInstructionLineByPC(reference);
                        if (pointerLine == null && (pointerLine = this.findInstructionLineByProgrammCounter(reference)) != null) {
                            for (Pointer pointer : platformData.getPlatformPointerList()) {
                                if (!pointer.matches(new Value(Math.min(valueA.getValue(), valueB.getValue())))) continue;
                                pointer.setType(RangeType.Code);
                                pointer.setReferenceType(ReferenceType.JumpMark);
                                resultPointer = pointer;
                                break;
                            }
                            if (resultPointer == null) {
                                resultPointer = new Pointer(reference, RangeType.Binary, ReferenceType.DataReference);
                            }
                            pointerLine.setReferenceValue(resultPointer.getAddress());
                            pointerA.setReferenceValue(new Value(reference.getValue(), ValueType.LOWBYTE));
                            pointerB.setReferenceValue(new Value(reference.getValue(), ValueType.HIGHBYTE));
                        }
                    }
                }
            }
        }
    }

    private boolean isDataAddress(Value value, PlatformData platformData) {
        boolean isPlatFormAddress = false;
        for (Address address : platformData.getPlatformAddressList()) {
            isPlatFormAddress = address.matches(value.getValue());
            if (isPlatFormAddress) break;
        }
        return isPlatFormAddress;
    }

    @Override
    public void compressRanges() {
        int index = 0;
        InstructionLine currentLine = null;
        while (index < this.getInstructionLineList().size() - 1) {
            currentLine = this.getInstructionLineList().get(index);
            if (currentLine.getReferenceType() == ReferenceType.DataReference) {
                InstructionLine nextLine;
                int nextIndex = index + 1;
                while (nextIndex <= this.getInstructionLineList().size() - 1 && (nextLine = this.getInstructionLineList().get(nextIndex)).getReferenceType() != ReferenceType.DataReference && nextLine.getInstructionType() != InstructionType.Asm) {
                    int length = currentLine.getRange().getLength();
                    this.getInstructionLineList().remove(nextLine);
                }
            }
            ++index;
        }
    }

    private boolean isStoreInstruction(String instruction) {
        return instruction.equals("sta") || instruction.equals("stx") || instruction.equals("sty");
    }

    public static String getInstructionTokenKey(boolean illegalOpcode, boolean unstableOpcode) {
        if (illegalOpcode && unstableOpcode) {
            return "UNSTABLE_ILLEGAL_OPCODE";
        }
        if (illegalOpcode && !unstableOpcode) {
            return "ILLEGAL_OPCODE";
        }
        return "OPCODE";
    }
}

