/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.cpu;

import de.drazil.nerdsuite.cpu.ICPU;
import de.drazil.nerdsuite.cpu.InstructionSet;
import de.drazil.nerdsuite.cpu.decode.InstructionLine;
import de.drazil.nerdsuite.model.Address;
import de.drazil.nerdsuite.model.DisassemblingRange;
import de.drazil.nerdsuite.model.Opcode;
import de.drazil.nerdsuite.model.PlatformData;
import de.drazil.nerdsuite.model.Range;
import de.drazil.nerdsuite.model.RangeType;
import de.drazil.nerdsuite.model.ReferenceType;
import de.drazil.nerdsuite.model.Value;
import de.drazil.nerdsuite.util.NumericConverter;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCPU
implements ICPU {
    protected int line;
    private static ICPU cpu = null;
    private static byte[] byteArray0 = null;
    private List<InstructionLine> instructionLineList = null;

    public AbstractCPU() {
        cpu = this;
        this.instructionLineList = new ArrayList<InstructionLine>();
    }

    public static ICPU getCPU() {
        return cpu;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void resetLine() {
        this.line = 0;
    }

    public static void setByteArray(byte[] byteArray) {
        byteArray0 = byteArray;
    }

    public static byte[] getByteArray() {
        return byteArray0;
    }

    @Override
    public int getByte(byte[] byteArray, int offset) {
        return NumericConverter.getByteAsInt(byteArray, offset);
    }

    @Override
    public Opcode getOpcodeByIndex(String platformId, String prefix, byte[] byteArray, int offset) {
        return this.getOpcodeById(platformId, prefix, NumericConverter.toInt(byteArray[offset]));
    }

    @Override
    public Opcode getOpcodeById(String platformId, String prefix, int opcode) {
        return InstructionSet.getOpcodeList(platformId, prefix).get(opcode);
    }

    @Override
    public void clear() {
        this.instructionLineList = new ArrayList<InstructionLine>();
    }

    @Override
    public void addInstructionLine(InstructionLine instructionLine) {
        this.instructionLineList.add(instructionLine);
    }

    @Override
    public InstructionLine splitInstructionLine(InstructionLine instructionLine, Value basePc, Value len) {
        return this.splitInstructionLine(instructionLine, basePc, len, RangeType.Unspecified, ReferenceType.NoReference);
    }

    @Override
    public InstructionLine splitInstructionLine(InstructionLine instructionLine, Value basePc, Value offset, RangeType rangeType, ReferenceType referenceType) {
        int newLen;
        Range range = instructionLine.getRange();
        int oldLen = range.getLength();
        if (oldLen == (newLen = offset.sub(range.getOffset()).getValue())) {
            return null;
        }
        range.setLength(newLen);
        InstructionLine newInstructionLine = new InstructionLine(basePc.add(range.getOffset() + newLen), new Range(range.getOffset() + newLen, oldLen - newLen));
        newInstructionLine.setReferenceType(referenceType);
        this.instructionLineList.add(this.instructionLineList.indexOf(instructionLine) + 1, newInstructionLine);
        return newInstructionLine;
    }

    @Override
    public InstructionLine findInstructionLineByProgrammCounter(Value programmCounter) {
        InstructionLine instructionLine = this.instructionLineList.stream().filter(il -> programmCounter.getValue() >= il.getProgramCounter().getValue() && programmCounter.getValue() <= il.getProgramCounter().getValue() + il.getRange().getLength() - 1).findFirst().orElse(null);
        return instructionLine;
    }

    @Override
    public int getIndexOf(InstructionLine line) {
        return this.instructionLineList.indexOf(line);
    }

    @Override
    public InstructionLine findInstructionLineByOffset(Value offset) {
        InstructionLine instructionLine = this.instructionLineList.stream().filter(il -> offset.getValue() >= il.getRange().getOffset() && offset.getValue() <= il.getRange().getOffset() + il.getRange().getLength() - 1).findFirst().orElse(null);
        return instructionLine;
    }

    @Override
    public InstructionLine getLastInstructionLine() {
        return this.instructionLineList.get(this.instructionLineList.size() - 1);
    }

    @Override
    public List<InstructionLine> getInstructionLineList() {
        return this.instructionLineList;
    }

    @Override
    public Value getInstructionValue(byte[] byteArray, Range range) {
        int value = 0;
        int len = range.getLength() - 1;
        switch (len) {
            case 1: {
                value = this.getByte(byteArray, range.getOffset() + 1);
                break;
            }
            case 2: {
                value = this.getWord(byteArray, range.getOffset() + 1);
            }
        }
        return new Value(value);
    }

    @Override
    public InstructionLine findInstructionLineByPC(Value programCounter) {
        if (programCounter == null) {
            return null;
        }
        return this.findInstructionLineByPC(programCounter.getValue());
    }

    @Override
    public InstructionLine findInstructionLineByPC(int programCounter) {
        InstructionLine instructionLine = this.instructionLineList.stream().filter(il -> il.getProgramCounter().getValue() == programCounter || programCounter >= il.getProgramCounter().getValue() && programCounter < il.getProgramCounter().getValue() + il.getRange().getLength()).findFirst().orElse(null);
        return instructionLine;
    }

    @Override
    public InstructionLine findInstructionLineByRef(Value reference) {
        return this.findInstructionLineByRef(reference.getValue());
    }

    protected boolean isPlatFormAddress(PlatformData platformData, int value) {
        boolean found = false;
        for (Address address : platformData.getPlatformAddressList()) {
            if (address.getAddressValue() != value) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public InstructionLine findInstructionLineByRef(int reference) {
        InstructionLine instructionLine = this.instructionLineList.stream().filter(il -> il.hasReferenceValue() && il.getReferenceValue().getValue() == reference).findFirst().orElse(null);
        return instructionLine;
    }

    @Override
    public void packInstructionLines(InstructionLine instructionLine, int len) {
        int lineIndex = this.getInstructionLineList().indexOf(instructionLine) + 1;
        int i = 0;
        while (i < len - 1) {
            this.getInstructionLineList().remove(lineIndex);
            ++i;
        }
        instructionLine.getRange().setLength(len);
    }

    public static String getMnemonicArgument(Opcode opcode, DisassemblingRange range, byte[] byteArray) {
        int len = range.getLen() - 1;
        int offset = range.getOffset() + 1;
        int value = 0;
        String argument = opcode.getAddressingMode().getArgumentTemplate();
        if (!(len <= 0 || (argument = argument.replace("{value}", "$" + NumericConverter.toHexString(value = len == 2 ? AbstractCPU.getCPU().getWord(byteArray, offset) : AbstractCPU.getCPU().getByte(byteArray, offset), len * 2))).endsWith(",X") || argument.endsWith(",Y") || argument.endsWith(",X)"))) {
            argument = String.valueOf(argument) + "  ";
        }
        return argument;
    }
}

