/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.configuration;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.model.Project;
import de.drazil.nerdsuite.model.Workspace;
import de.drazil.nerdsuite.util.FileUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class Configuration {
    private Logger log;
    public static final File WORKSPACE_PATH = java.nio.file.Path.of(Constants.USER_HOME, Constants.FILE_SEPARATOR, ".nerdsuiteWorkspace").toFile();
    public static final File SETTINGS_FILE = java.nio.file.Path.of(Constants.USER_HOME, Constants.FILE_SEPARATOR, ".nerdsuiteWorkspace", Constants.FILE_SEPARATOR, ".settings").toFile();
    private Workspace workspace;

    public Configuration(IEclipseContext workbenchContext) {
        this.log = (Logger)workbenchContext.get(Logger.class.getName());
    }

    public final Workspace getWorkspace() {
        return this.createOrReadWorkspace();
    }

    public void initialize() {
        try {
            this.workspace = this.getWorkspace();
            Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
            String[] stringArray = Constants.FONT_LIST;
            int n = Constants.FONT_LIST.length;
            int n2 = 0;
            while (n2 < n) {
                String pathFragment = stringArray[n2];
                Path path = new Path(pathFragment);
                URL url = FileLocator.find((Bundle)bundle, (IPath)path, (Map)Collections.EMPTY_MAP);
                URL fileUrl = null;
                try {
                    fileUrl = FileLocator.toFileURL((URL)url);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                File file = new File(fileUrl.getPath());
                boolean fontLoaded = Display.getCurrent().loadFont(file.toString());
                System.out.printf("font [ %s ] %s loaded\n", pathFragment, fontLoaded ? "" : " not ");
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final Workspace createOrReadWorkspace() {
        try {
            if (!WORKSPACE_PATH.exists()) {
                this.log.debug("create new workspace folder...");
                WORKSPACE_PATH.mkdir();
                this.workspace = new Workspace();
                this.updateWorkspace(null, false, false);
            }
            if (!SETTINGS_FILE.exists()) {
                SETTINGS_FILE.createNewFile();
                FileWriter fw = new FileWriter(SETTINGS_FILE);
                fw.write("#ultimate64 settings\nu64.host.address=\nu64.host.port=\n");
                fw.flush();
                fw.close();
            }
            if (!System.getProperties().contains("nerdsuitePropertiesRead")) {
                Properties p = new Properties();
                p.load(new FileReader(SETTINGS_FILE));
                Enumeration<Object> e = p.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    System.setProperty(key, p.getProperty(key));
                }
                System.setProperty("nerdsuitePropertiesRead", "true");
            }
            System.getProperties().setProperty("u64.client.address", Inet4Address.getLocalHost().getHostAddress());
            if (this.workspace == null) {
                this.log.debug("read workspace file...");
                ObjectMapper mapper = new ObjectMapper();
                this.workspace = (Workspace)mapper.readValue(new File(WORKSPACE_PATH + Constants.FILE_SEPARATOR + ".projects.json"), Workspace.class);
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.workspace;
    }

    public final void updateWorkspace(Project project, boolean addProject, boolean mountOnly) {
        if (addProject) {
            this.workspace.add(project);
            try {
                if (!mountOnly) {
                    File file = FileUtil.getFileFromProject(project);
                    file.createNewFile();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            File projectPath = new File(WORKSPACE_PATH + Constants.FILE_SEPARATOR + ".projects.json");
            this.log.debug(projectPath.getAbsolutePath());
            mapper.writeValue(projectPath, (Object)this.workspace);
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

