/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.basic.encode;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.drazil.nerdsuite.configuration.Initializer;
import de.drazil.nerdsuite.imaging.service.IService;
import de.drazil.nerdsuite.model.Project;
import de.drazil.nerdsuite.model.SourceContainer;
import de.drazil.nerdsuite.model.SourceMetadata;
import de.drazil.nerdsuite.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import org.eclipse.swt.graphics.Rectangle;

public class SourceRepositoryService
implements IService {
    private String owner = null;
    private Rectangle selection;
    private SourceContainer container = new SourceContainer();

    public void setMetadata(SourceMetadata metadata) {
        this.container.setMetadata(metadata);
    }

    public SourceMetadata getMetadata() {
        return this.container.getMetadata();
    }

    public SourceContainer load(String id) {
        return this.load(id, false);
    }

    public String getContent() {
        return this.container.getContent();
    }

    public void setContent(String content) {
        this.container.setContent(content);
    }

    public SourceContainer load(String id, boolean isReference) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        try {
            Project project = Initializer.getConfiguration().getWorkspace().getProjectById(id);
            File file = FileUtil.getFileFromProject(project);
            this.container = (SourceContainer)mapper.readValue(file, SourceContainer.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.container;
    }

    public void save(Project project) {
        try {
            File file = FileUtil.getFileFromProject(project);
            FileWriter fw = new FileWriter(file, StandardCharsets.UTF_8);
            fw.write(SourceRepositoryService.getHeaderText(project, this.container.getMetadata()));
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.writeValue((Writer)fw, (Object)this.container);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getHeaderText(Project project, SourceMetadata metadata) {
        String s = String.format("// Nerdsuite Project by drazil 2017-2022\n// Projectname_____: %s\n// Created on______: %s\n// Changed on______: %s\n", project.getName(), DateFormat.getDateInstance(3).format(project.getCreatedOn()), DateFormat.getDateInstance(3).format(project.getChangedOn()));
        return s;
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Rectangle getSelection() {
        return this.selection;
    }

    public void setSelection(Rectangle selection) {
        this.selection = selection;
    }
}

