/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.basic.encode;

import de.drazil.nerdsuite.model.BasicInstruction;
import de.drazil.nerdsuite.model.BasicInstructions;
import de.drazil.nerdsuite.model.CharObject;
import de.drazil.nerdsuite.util.ArrayUtil;
import de.drazil.nerdsuite.util.NumericConverter;
import java.text.StringCharacterIterator;
import java.util.List;

public class CpcBasicEncoder {
    private static Mode readMode;
    private static Mode lastReadMode;
    private static LastRead lastRead;

    static {
        lastReadMode = readMode = Mode.READ_LINENUMBER;
        lastRead = LastRead.NONE;
    }

    public static byte[] tokenize(String content, BasicInstructions basicInstructions, List<CharObject> charMap) {
        long startTime = System.currentTimeMillis();
        boolean doNotScan = false;
        byte[] result = new byte[]{};
        int offset = 0;
        char quote = basicInstructions.getStringQuote().charAt(0);
        StringCharacterIterator ci = new StringCharacterIterator(content);
        StringBuilder buffer = new StringBuilder();
        char ch = ci.first();
        while (ch != '\uffff') {
            if (content.indexOf(basicInstructions.getBlockComment()[0], ci.getIndex()) == ci.getIndex()) {
                System.out.printf("block start index at %s\n", ci.getIndex());
                ci.setIndex(ci.getIndex() + 1);
                lastReadMode = readMode;
                readMode = Mode.READ_BLOCK_COMMENT;
            }
            if (content.indexOf(basicInstructions.getSingleLineComment(), ci.getIndex()) == ci.getIndex() && readMode != Mode.READ_BLOCK_COMMENT) {
                lastReadMode = readMode;
                readMode = Mode.READ_LINE_COMMENT;
            }
            switch (readMode) {
                case READ_BLOCK_COMMENT: {
                    int match = 0;
                    match = content.indexOf(basicInstructions.getBlockComment()[1], ci.getIndex());
                    if (match == -1) break;
                    ci.setIndex(match + 1);
                    readMode = lastReadMode;
                    break;
                }
                case READ_LINE_COMMENT: {
                    if (content.indexOf("\n", ci.getIndex()) != ci.getIndex()) break;
                    readMode = lastReadMode;
                    break;
                }
                case READ_LINENUMBER: {
                    if ((ch != '\n' && ch != '\r' && Character.isWhitespace(ch) || Character.isAlphabetic(ch)) && lastRead == LastRead.NUMERIC) {
                        readMode = Mode.READ_INSTRUCTIONS;
                        byte[] ba = NumericConverter.getWord(Integer.valueOf(buffer.toString()));
                        result = ArrayUtil.grow(result, new byte[2]);
                        result = ArrayUtil.grow(result, ba);
                        buffer = new StringBuilder();
                        if (Character.isWhitespace(ch)) break;
                        buffer.append(ch);
                        break;
                    }
                    if (!Character.isDigit(ch)) break;
                    lastRead = LastRead.NUMERIC;
                    buffer.append(ch);
                    break;
                }
                case READ_INSTRUCTIONS: {
                    boolean found = false;
                    if (!doNotScan) {
                        int start = ci.getIndex();
                        for (BasicInstruction instruction : basicInstructions.getBasicInstructionList()) {
                            if (content.indexOf(instruction.getInstruction().toUpperCase(), start) != start) continue;
                            doNotScan = instruction.isComment();
                            result = ArrayUtil.grow(result, buffer.toString().getBytes());
                            int index = instruction.getSelectedTokenIndex();
                            byte b = (byte)(Integer.parseInt(instruction.getTokens().get(index).getToken(), 16) & 0xFF);
                            result = ArrayUtil.grow(result, b);
                            ci.setIndex(start + (instruction.getInstruction().length() - 1));
                            buffer = new StringBuilder();
                            found = true;
                            break;
                        }
                        if (!found && ch != '\r' && ch != '\n') {
                            buffer.append(ch);
                        }
                    } else if (ch != '\r' && ch != '\n') {
                        buffer.append(ch);
                    }
                    if (ch == quote) {
                        readMode = Mode.READ_STRING;
                        break;
                    }
                    if (ch != '\n') break;
                    doNotScan = false;
                    result = ArrayUtil.grow(result, buffer.toString().getBytes());
                    result = ArrayUtil.grow(result, (byte)0);
                    int len = result.length;
                    result = ArrayUtil.update(result, NumericConverter.getWord(2049 + len), offset);
                    offset = len;
                    buffer = new StringBuilder();
                    readMode = Mode.READ_LINENUMBER;
                    break;
                }
                case READ_STRING: {
                    buffer.append(ch);
                    if (ch != quote) break;
                    byte[] ba = CpcBasicEncoder.mapUniCodeCharacters(buffer, charMap);
                    result = ArrayUtil.grow(result, ba);
                    buffer = new StringBuilder();
                    readMode = Mode.READ_INSTRUCTIONS;
                }
            }
            ch = ci.next();
        }
        result = ArrayUtil.grow(result, new byte[2]);
        float diff = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        System.out.printf("time to build:%f seconds\n", Float.valueOf(diff));
        return result;
    }

    private static byte[] mapUniCodeCharacters(StringBuilder sb, List<CharObject> charMap) {
        byte[] ba = new byte[sb.length()];
        StringCharacterIterator ci = new StringCharacterIterator(sb.toString());
        char ch = ci.first();
        while (ch != '\uffff') {
            boolean found = false;
            for (CharObject cm : charMap) {
                int i = Character.getType(ch);
                if (ch != cm.getUnicode() || i != 18) continue;
                ba[ci.getIndex()] = (byte)cm.getId();
                found = true;
                break;
            }
            if (!found) {
                ba[ci.getIndex()] = (byte)ch;
            }
            ch = ci.next();
        }
        return ba;
    }

    static enum LastRead {
        NUMERIC,
        ALPHANUMERIC,
        LETTER,
        WHITESPACE,
        NONE;

    }

    static enum Mode {
        READ_LINENUMBER,
        READ_INSTRUCTIONS,
        READ_STRING,
        READ_BLOCK_COMMENT,
        READ_LINE_COMMENT;

    }
}

