/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.basic.encode;

import de.drazil.nerdsuite.basic.encode.AbstractTokenEncoder;
import de.drazil.nerdsuite.model.BasicInstruction;
import de.drazil.nerdsuite.model.BasicInstructions;
import de.drazil.nerdsuite.model.CharObject;
import de.drazil.nerdsuite.util.ArrayUtil;
import de.drazil.nerdsuite.util.NumericConverter;
import java.text.StringCharacterIterator;
import java.util.List;

public class CbmBasicEncoder
extends AbstractTokenEncoder {
    @Override
    public byte[] encode(String content, BasicInstructions basicInstructions, List<CharObject> charMap, boolean debug) {
        AbstractTokenEncoder.Mode readMode;
        this.isInDebugMode = debug;
        boolean doNotScan = false;
        byte[] result = new byte[]{};
        int offset = 0;
        char quote = basicInstructions.getStringQuote().charAt(0);
        this.ci = new StringCharacterIterator(content);
        StringBuilder buffer = new StringBuilder();
        char ch = '\u0000';
        AbstractTokenEncoder.Mode lastReadMode = readMode = AbstractTokenEncoder.Mode.READ_LINENUMBER;
        AbstractTokenEncoder.LastRead lastRead = AbstractTokenEncoder.LastRead.NONE;
        ch = this.ci.first();
        block7: while (ch != '\uffff') {
            if (content.indexOf(basicInstructions.getBlockComment()[0], this.ci.getIndex()) == this.ci.getIndex()) {
                System.out.printf("block start index at %s\n", this.ci.getIndex());
                this.ci.setIndex(this.ci.getIndex() + 1);
                lastReadMode = readMode;
                readMode = AbstractTokenEncoder.Mode.READ_BLOCK_COMMENT;
            }
            if (content.indexOf(basicInstructions.getSingleLineComment(), this.ci.getIndex()) == this.ci.getIndex() && readMode != AbstractTokenEncoder.Mode.READ_BLOCK_COMMENT) {
                lastReadMode = readMode;
                readMode = AbstractTokenEncoder.Mode.READ_LINE_COMMENT;
            }
            this.processMetaDirective(content, this.ci.getIndex(), true);
            ch = this.ci.current();
            switch (readMode) {
                case READ_BLOCK_COMMENT: {
                    int match = 0;
                    while ((match = content.indexOf(basicInstructions.getBlockComment()[1], this.ci.getIndex())) != -1) {
                        ch = this.ci.next();
                    }
                    ch = this.ci.next();
                    readMode = lastReadMode;
                    break;
                }
                case READ_LINE_COMMENT: {
                    if (content.indexOf("\n", this.ci.getIndex()) != this.ci.getIndex()) break;
                    readMode = lastReadMode;
                    break;
                }
                case READ_LINENUMBER: {
                    if (Character.isLetter(ch) || ch == ':') {
                        this.isInDataLine = false;
                        readMode = AbstractTokenEncoder.Mode.READ_INSTRUCTIONS;
                        byte[] ba = NumericConverter.getWord(Integer.valueOf(buffer.toString()));
                        result = ArrayUtil.grow(result, new byte[2]);
                        result = ArrayUtil.grow(result, ba);
                        buffer = new StringBuilder();
                    }
                    while (Character.isWhitespace(ch)) {
                        ch = this.ci.next();
                    }
                    while (Character.isDigit(ch)) {
                        buffer.append(ch);
                        ch = this.ci.next();
                    }
                    continue block7;
                }
                case READ_INSTRUCTIONS: {
                    boolean found = false;
                    if (!doNotScan) {
                        int start = this.ci.getIndex();
                        for (BasicInstruction instruction : basicInstructions.getBasicInstructionList()) {
                            if (content.indexOf(instruction.getInstruction().toUpperCase(), start) != start || instruction.getPurpose().equals("R")) continue;
                            if (instruction.getInstruction().equalsIgnoreCase("data") && !this.isInDataLine) {
                                this.isInDataLine = true;
                            }
                            doNotScan = instruction.isComment();
                            result = ArrayUtil.grow(result, buffer.toString().getBytes());
                            int index = instruction.getSelectedTokenIndex();
                            String token = instruction.getTokens().get(index).getToken();
                            int b = Integer.parseInt(token, 16) & 0xFF;
                            if (this.isInDataLine && instruction.getInstruction().equals("-")) {
                                b = 45;
                            }
                            result = ArrayUtil.grow(result, (byte)b);
                            this.ci.setIndex(start + (instruction.getInstruction().length() - 1));
                            buffer = new StringBuilder();
                            found = true;
                            break;
                        }
                        if (!found && !Character.isWhitespace(ch)) {
                            buffer.append(ch);
                        }
                    } else if (!Character.isWhitespace(ch)) {
                        buffer.append(ch);
                    }
                    if (ch == quote) {
                        readMode = AbstractTokenEncoder.Mode.READ_STRING;
                    } else if (ch == '\n' || this.ci.getIndex() == content.length() - 1) {
                        doNotScan = false;
                        result = ArrayUtil.grow(result, buffer.toString().getBytes());
                        result = ArrayUtil.grow(result, (byte)0);
                        int len = result.length;
                        result = ArrayUtil.update(result, NumericConverter.getWord(2049 + len), offset);
                        offset = len;
                        buffer = new StringBuilder();
                        readMode = AbstractTokenEncoder.Mode.READ_LINENUMBER;
                    }
                    ch = this.ci.next();
                    break;
                }
                case READ_STRING: {
                    buffer.append(ch);
                    if (ch == quote) {
                        byte[] ba = this.mapUniCodeCharacters(buffer, charMap);
                        result = ArrayUtil.grow(result, ba);
                        buffer = new StringBuilder();
                        readMode = AbstractTokenEncoder.Mode.READ_INSTRUCTIONS;
                    }
                    ch = this.ci.next();
                }
            }
        }
        result = ArrayUtil.grow(result, new byte[2]);
        return result;
    }
}

