/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.basic.encode;

import de.drazil.nerdsuite.basic.encode.ITokenEncoder;
import de.drazil.nerdsuite.log.Console;
import de.drazil.nerdsuite.model.CharObject;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractTokenEncoder
implements ITokenEncoder {
    protected Pattern directivePattern = Pattern.compile("(@[a-zA-Z]*)\\s*([a-zA-Z]*)?");
    protected CharacterIterator ci;
    protected boolean isInDataLine = false;
    protected boolean isInDebugMode = false;
    protected boolean isInIfBlock = false;
    protected boolean isInElseBlock = false;

    protected byte[] mapUniCodeCharacters(StringBuilder sb, List<CharObject> charMap) {
        byte[] ba = new byte[sb.length()];
        StringCharacterIterator ci = new StringCharacterIterator(sb.toString());
        char ch = ci.first();
        while (ch != '\uffff') {
            boolean found = false;
            for (CharObject cm : charMap) {
                int i = Character.getType(ch);
                if (ch != cm.getUnicode() || i != 18) continue;
                ba[ci.getIndex()] = (byte)cm.getId();
                found = true;
                break;
            }
            if (!found) {
                ba[ci.getIndex()] = (byte)ch;
            }
            ch = ci.next();
        }
        return ba;
    }

    protected void processMetaDirective(String content, int startIndex, boolean lineOnly) {
        Matcher matcher = this.directivePattern.matcher(content);
        if (lineOnly) {
            int end = content.indexOf(13, startIndex);
            matcher.region(startIndex, end != -1 ? end : content.length() - 1);
        } else {
            matcher.region(startIndex, content.length());
        }
        if (matcher.find()) {
            int count = matcher.groupCount();
            String m1 = matcher.group(1);
            String m2 = matcher.group(2);
            if (count == 2 && m2.equals("")) {
                if (matcher.group(1).equalsIgnoreCase("@end")) {
                    this.ci.setIndex(matcher.start() + matcher.group(1).length() + 1);
                    if (!this.isInIfBlock) {
                        Console.println("@END without @IF");
                        return;
                    }
                    this.isInIfBlock = false;
                    this.isInElseBlock = false;
                }
                if (matcher.group(1).equalsIgnoreCase("@else")) {
                    this.ci.setIndex(matcher.start() + matcher.group(1).length() + 1);
                    if (!this.isInIfBlock) {
                        Console.println("@ELSE without @IF");
                        return;
                    }
                    this.isInElseBlock = true;
                    if (this.isInDebugMode) {
                        this.processMetaDirective(content, this.ci.getIndex(), false);
                    }
                }
            } else if (count == 2 && !m1.equals(matcher) && !m2.equals(matcher) && matcher.group(1).equalsIgnoreCase("@if") && matcher.group(2).equalsIgnoreCase("debug")) {
                this.isInIfBlock = true;
                this.ci.setIndex(startIndex + matcher.group().length() + 1);
                if (!this.isInDebugMode) {
                    this.processMetaDirective(content, this.ci.getIndex(), false);
                }
            }
        }
    }

    static enum LastRead {
        NUMERIC,
        ALPHANUMERIC,
        LETTER,
        WHITESPACE,
        NONE;

    }

    static enum Mode {
        READ_LINENUMBER,
        READ_INSTRUCTIONS,
        READ_STRING,
        READ_BLOCK_COMMENT,
        READ_LINE_COMMENT,
        READ_DEBUG_BLOCK;

    }
}

