/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.basic.decode;

import de.drazil.nerdsuite.cpu.ICPU;
import de.drazil.nerdsuite.model.BasicInstruction;
import de.drazil.nerdsuite.model.Value;
import de.drazil.nerdsuite.util.NumericConverter;
import java.util.Map;

public class BasicParser {
    private ICPU cpu;
    private Value basicStart;
    private Map<String, BasicInstruction> basicTokenMap;
    private int openBraces = 0;
    private int closedBraces = 0;
    private int openQuotes = 0;
    private int closedQuotes = 0;
    private boolean insideQuotes = false;

    public BasicParser(Value basicStart, ICPU cpu, Map<String, BasicInstruction> basicTokenMap) {
        this.basicStart = basicStart;
        this.cpu = cpu;
        this.basicTokenMap = basicTokenMap;
    }

    public ICPU getCPU() {
        return this.cpu;
    }

    public Value getLastBasicLineAddress(byte[] byteArray, int offset) {
        int arrayIndex = offset;
        Value nextBasicLineAddress = null;
        while ((nextBasicLineAddress = new Value(this.getCPU().getWord(byteArray, arrayIndex))).getValue() != 0) {
            arrayIndex = nextBasicLineAddress.sub(this.basicStart).getValue();
        }
        return this.basicStart.add(arrayIndex);
    }

    public String start(byte[] byteArray, Value startAdress) {
        StringBuffer sb = new StringBuffer();
        int nextLineAdress = -1;
        int lineNumberAddressOffset = 0;
        int offset = this.basicStart.sub(startAdress).getValue();
        while ((nextLineAdress = new Value(this.getCPU().getWord(byteArray, offset)).getValue()) != 0) {
            lineNumberAddressOffset = offset + 2;
            sb.append(this.scanLine(byteArray, lineNumberAddressOffset) + "\n");
            offset = nextLineAdress - this.basicStart.getValue();
        }
        return sb.toString();
    }

    private StringBuffer scanLine(byte[] byteArray, int lineNumberAddressOffset) {
        byte currentByte;
        this.insideQuotes = false;
        int lineNumber = this.getCPU().getWord(byteArray, lineNumberAddressOffset);
        int linePos = lineNumberAddressOffset + 2;
        StringBuffer lineBuffer = new StringBuffer(String.valueOf(lineNumber) + " ");
        while ((currentByte = byteArray[linePos]) != 0) {
            switch (currentByte) {
                case 34: {
                    this.insideQuotes = !this.insideQuotes;
                }
            }
            BasicInstruction instruction = null;
            if (!this.insideQuotes && (instruction = this.basicTokenMap.get(NumericConverter.toHexString(this.getCPU().getByte(byteArray, linePos), 2))) != null) {
                lineBuffer.append(instruction.getInstruction().toUpperCase());
            }
            if (instruction == null) {
                lineBuffer.append((char)currentByte);
            }
            ++linePos;
        }
        return lineBuffer;
    }
}

